/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryUpdateResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=701");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=703");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=702");
    private final ResponseHeader responseHeader;
    private final HistoryUpdateResult[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public HistoryUpdateResponse(ResponseHeader responseHeader, HistoryUpdateResult[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public HistoryUpdateResult[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected HistoryUpdateResponse(HistoryUpdateResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((HistoryUpdateResponseBuilder)b).responseHeader;
        this.results = ((HistoryUpdateResponseBuilder)b).results;
        this.diagnosticInfos = ((HistoryUpdateResponseBuilder)b).diagnosticInfos;
    }

    public static HistoryUpdateResponseBuilder<?, ?> builder() {
        return new HistoryUpdateResponseBuilderImpl();
    }

    public HistoryUpdateResponseBuilder<?, ?> toBuilder() {
        return new HistoryUpdateResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryUpdateResponse)) {
            return false;
        }
        HistoryUpdateResponse other = (HistoryUpdateResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryUpdateResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryUpdateResponse(responseHeader=" + this.getResponseHeader() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class HistoryUpdateResponseBuilderImpl
    extends HistoryUpdateResponseBuilder<HistoryUpdateResponse, HistoryUpdateResponseBuilderImpl> {
        private HistoryUpdateResponseBuilderImpl() {
        }

        @Override
        protected HistoryUpdateResponseBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryUpdateResponse build() {
            return new HistoryUpdateResponse(this);
        }
    }

    public static abstract class HistoryUpdateResponseBuilder<C extends HistoryUpdateResponse, B extends HistoryUpdateResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private HistoryUpdateResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryUpdateResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryUpdateResponse instance, HistoryUpdateResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B results(HistoryUpdateResult[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryUpdateResponse.HistoryUpdateResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryUpdateResponse> {
        @Override
        public Class<HistoryUpdateResponse> getType() {
            return HistoryUpdateResponse.class;
        }

        @Override
        public HistoryUpdateResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            HistoryUpdateResult[] results = (HistoryUpdateResult[])decoder.readStructArray("Results", HistoryUpdateResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new HistoryUpdateResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryUpdateResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Results", (Object[])value.getResults(), HistoryUpdateResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

