/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ProgressIndexManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ProgressIndexDataNodeManager
implements ProgressIndexManager {
    private final Map<ConsensusGroupId, ProgressIndex> groupId2MaxProgressIndex = new ConcurrentHashMap<ConsensusGroupId, ProgressIndex>();
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();

    public ProgressIndexDataNodeManager() {
        this.recoverMaxProgressIndexFromDataRegion();
    }

    private void recoverMaxProgressIndexFromDataRegion() {
        StorageEngine.getInstance().getAllDataRegionIds().forEach(dataRegionId -> {
            TsFileManager tsFileManager = StorageEngine.getInstance().getDataRegion((DataRegionId)dataRegionId).getTsFileManager();
            ArrayList allProgressIndex = new ArrayList();
            allProgressIndex.addAll(tsFileManager.getTsFileList(true).stream().map(TsFileResource::getMaxProgressIndex).collect(Collectors.toList()));
            allProgressIndex.addAll(tsFileManager.getTsFileList(false).stream().map(TsFileResource::getMaxProgressIndex).collect(Collectors.toList()));
            MinimumProgressIndex maxProgressIndex = MinimumProgressIndex.INSTANCE;
            for (ProgressIndex progressIndex : allProgressIndex) {
                maxProgressIndex = maxProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(this.extractLocalSimpleProgressIndex(progressIndex));
            }
            MinimumProgressIndex finalMaxProgressIndex = maxProgressIndex;
            this.groupId2MaxProgressIndex.compute((ConsensusGroupId)dataRegionId, (arg_0, arg_1) -> ProgressIndexDataNodeManager.lambda$recoverMaxProgressIndexFromDataRegion$0((ProgressIndex)finalMaxProgressIndex, arg_0, arg_1));
        });
    }

    private ProgressIndex extractLocalSimpleProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex instanceof RecoverProgressIndex) {
            Map dataNodeId2LocalIndex = ((RecoverProgressIndex)progressIndex).getDataNodeId2LocalIndex();
            return dataNodeId2LocalIndex.containsKey(DATA_NODE_ID) ? (ProgressIndex)dataNodeId2LocalIndex.get(DATA_NODE_ID) : MinimumProgressIndex.INSTANCE;
        }
        if (progressIndex instanceof HybridProgressIndex) {
            Map type2Index = ((HybridProgressIndex)progressIndex).getType2Index();
            if (!type2Index.containsKey(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())) {
                return MinimumProgressIndex.INSTANCE;
            }
            Map dataNodeId2LocalIndex = ((RecoverProgressIndex)type2Index.get(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())).getDataNodeId2LocalIndex();
            return dataNodeId2LocalIndex.containsKey(DATA_NODE_ID) ? (ProgressIndex)dataNodeId2LocalIndex.get(DATA_NODE_ID) : MinimumProgressIndex.INSTANCE;
        }
        return MinimumProgressIndex.INSTANCE;
    }

    public ProgressIndex getProgressIndex(ConsensusPipeName consensusPipeName) {
        return PipeDataNodeAgent.task().getPipeTaskProgressIndex(consensusPipeName.toString(), consensusPipeName.getConsensusGroupId().getId());
    }

    public ProgressIndex assignProgressIndex(ConsensusGroupId consensusGroupId) {
        return this.groupId2MaxProgressIndex.compute(consensusGroupId, (key, value) -> (value == null ? MinimumProgressIndex.INSTANCE : value).updateToMinimumEqualOrIsAfterProgressIndex(PipeDataNodeAgent.runtime().assignProgressIndexForPipeConsensus()));
    }

    public ProgressIndex getMaxAssignedProgressIndex(ConsensusGroupId consensusGroupId) {
        return this.groupId2MaxProgressIndex.getOrDefault(consensusGroupId, (ProgressIndex)MinimumProgressIndex.INSTANCE);
    }

    private static /* synthetic */ ProgressIndex lambda$recoverMaxProgressIndexFromDataRegion$0(ProgressIndex finalMaxProgressIndex, ConsensusGroupId key, ProgressIndex value) {
        return (value == null ? MinimumProgressIndex.INSTANCE : value).updateToMinimumEqualOrIsAfterProgressIndex(finalMaxProgressIndex);
    }
}

