/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTsFileEpochProgressIndexKeeper;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class PipeCompactedTsFileInsertionEvent
extends PipeTsFileInsertionEvent {
    private final String dataRegionId;
    private final Set<String> originFilePaths;
    private final List<Long> commitIds;

    public PipeCompactedTsFileInsertionEvent(CommitterKey committerKey, Set<PipeTsFileInsertionEvent> originalEvents, PipeTsFileInsertionEvent anyOfOriginalEvents, TsFileResource tsFileResource, boolean shouldReportProgress) {
        super(tsFileResource, null, PipeCompactedTsFileInsertionEvent.bindIsWithMod(originalEvents), PipeCompactedTsFileInsertionEvent.bindIsLoaded(originalEvents), PipeCompactedTsFileInsertionEvent.bindIsGeneratedByHistoricalExtractor(originalEvents), committerKey.getPipeName(), committerKey.getCreationTime(), anyOfOriginalEvents.getPipeTaskMeta(), anyOfOriginalEvents.getPipePattern(), anyOfOriginalEvents.getStartTime(), anyOfOriginalEvents.getEndTime());
        this.dataRegionId = String.valueOf(committerKey.getRegionId());
        this.originFilePaths = originalEvents.stream().map(PipeTsFileInsertionEvent::getTsFile).map(File::getPath).collect(Collectors.toSet());
        this.commitIds = originalEvents.stream().map(EnrichedEvent::getCommitId).distinct().collect(Collectors.toList());
        this.committerKey = committerKey;
        this.isPatternParsed = PipeCompactedTsFileInsertionEvent.bindIsPatternParsed(originalEvents);
        this.isTimeParsed = PipeCompactedTsFileInsertionEvent.bindIsTimeParsed(originalEvents);
        this.shouldReportOnCommit = shouldReportProgress;
        this.flushPointCount = PipeCompactedTsFileInsertionEvent.bindFlushPointCount(originalEvents);
        this.overridingProgressIndex = this.bindOverridingProgressIndex(originalEvents);
    }

    private static boolean bindIsWithMod(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().anyMatch(PipeTsFileInsertionEvent::isWithMod);
    }

    private static boolean bindIsLoaded(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().anyMatch(PipeTsFileInsertionEvent::isLoaded);
    }

    private static boolean bindIsGeneratedByHistoricalExtractor(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().anyMatch(PipeTsFileInsertionEvent::isGeneratedByHistoricalExtractor);
    }

    private static boolean bindIsTimeParsed(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().noneMatch(EnrichedEvent::shouldParseTime);
    }

    private static boolean bindIsPatternParsed(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().noneMatch(EnrichedEvent::shouldParsePattern);
    }

    private static long bindFlushPointCount(Set<PipeTsFileInsertionEvent> originalEvents) {
        return originalEvents.stream().mapToLong(e -> e.getFlushPointCount() == -1L ? 0L : e.getFlushPointCount()).sum();
    }

    private ProgressIndex bindOverridingProgressIndex(Set<PipeTsFileInsertionEvent> originalEvents) {
        MinimumProgressIndex overridingProgressIndex = MinimumProgressIndex.INSTANCE;
        for (PipeTsFileInsertionEvent originalEvent : originalEvents) {
            if (originalEvent.overridingProgressIndex == null) continue;
            overridingProgressIndex = overridingProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(originalEvent.overridingProgressIndex);
        }
        return overridingProgressIndex != null && !overridingProgressIndex.equals((ProgressIndex)MinimumProgressIndex.INSTANCE) ? overridingProgressIndex : null;
    }

    public int getRebootTimes() {
        throw new UnsupportedOperationException("PipeCompactedTsFileInsertionEvent does not support getRebootTimes.");
    }

    public boolean hasMultipleCommitIds() {
        return true;
    }

    public long getCommitId() {
        return (Long)this.commitIds.stream().max(Long::compareTo).orElseThrow(() -> new IllegalStateException("No commit IDs found in PipeCompactedTsFileInsertionEvent."));
    }

    public List<EnrichedEvent> getDummyEventsForCommitIds() {
        return this.commitIds.stream().filter(commitId -> commitId.longValue() != this.getCommitId()).map(x$0 -> new PipeCompactedTsFileInsertionDummyEvent((long)x$0)).collect(Collectors.toList());
    }

    public List<Long> getCommitIds() {
        return this.commitIds;
    }

    public boolean equalsInPipeConsensus(Object o) {
        throw new UnsupportedOperationException("PipeCompactedTsFileInsertionEvent does not support equalsInPipeConsensus.");
    }

    @Override
    public void eliminateProgressIndex() {
        if (Objects.isNull(this.overridingProgressIndex)) {
            for (String originFilePath : this.originFilePaths) {
                PipeTsFileEpochProgressIndexKeeper.getInstance().eliminateProgressIndex(this.dataRegionId, this.pipeName, originFilePath);
            }
        }
    }

    public class PipeCompactedTsFileInsertionDummyEvent
    extends EnrichedEvent {
        private final long commitId;

        public PipeCompactedTsFileInsertionDummyEvent(long commitId) {
            super(PipeCompactedTsFileInsertionEvent.this.pipeName, PipeCompactedTsFileInsertionEvent.this.creationTime, PipeCompactedTsFileInsertionEvent.this.pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
            this.commitId = commitId;
            this.shouldReportOnCommit = false;
        }

        public long getCommitId() {
            return this.commitId;
        }

        public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
            return true;
        }

        public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
            return true;
        }

        public ProgressIndex getProgressIndex() {
            return MinimumProgressIndex.INSTANCE;
        }

        public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
            return null;
        }

        public boolean isGeneratedByPipe() {
            return false;
        }

        public boolean mayEventTimeOverlappedWithTimeRange() {
            return false;
        }

        public boolean mayEventPathsOverlappedWithPattern() {
            return false;
        }

        public String coreReportMessage() {
            return "PipeCompactedTsFileInsertionDummyEvent";
        }
    }
}

