/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.AbstractLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;

public class GreedyLeaderBalancer
extends AbstractLeaderBalancer {
    @Override
    public Map<TConsensusGroupId, Integer> generateOptimalLeaderDistribution(Map<String, List<TConsensusGroupId>> databaseRegionGroupMap, Map<TConsensusGroupId, Set<Integer>> regionLocationMap, Map<TConsensusGroupId, Integer> regionLeaderMap, Map<Integer, NodeStatistics> dataNodeStatisticsMap, Map<TConsensusGroupId, Map<Integer, RegionStatistics>> regionStatisticsMap) {
        this.initialize(databaseRegionGroupMap, regionLocationMap, regionLeaderMap, dataNodeStatisticsMap, regionStatisticsMap);
        Map<TConsensusGroupId, Integer> result = this.constructGreedyDistribution();
        this.clear();
        return result;
    }

    private Map<TConsensusGroupId, Integer> constructGreedyDistribution() {
        TreeMap leaderCounter = new TreeMap();
        this.regionLocationMap.forEach((regionGroupId, dataNodeIds) -> {
            int minCount = Integer.MAX_VALUE;
            int leaderId = this.regionLeaderMap.getOrDefault(regionGroupId, -1);
            Iterator iterator = dataNodeIds.iterator();
            while (iterator.hasNext()) {
                int count;
                int dataNodeId = (Integer)iterator.next();
                if (!this.isDataNodeAvailable(dataNodeId) || !this.isRegionAvailable((TConsensusGroupId)regionGroupId, dataNodeId) || (count = leaderCounter.getOrDefault(dataNodeId, 0).intValue()) >= minCount) continue;
                minCount = count;
                leaderId = dataNodeId;
            }
            this.regionLeaderMap.put(regionGroupId, leaderId);
            leaderCounter.merge(leaderId, 1, Integer::sum);
        });
        return new ConcurrentHashMap<TConsensusGroupId, Integer>(this.regionLeaderMap);
    }
}

