/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.server.console.entity.vo.BranchSessionVO;
import org.apache.seata.server.console.impl.AbstractBranchService;
import org.apache.seata.server.console.service.BranchSessionService;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManager;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManagerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${sessionMode}')}")
public class BranchSessionRedisServiceImpl
extends AbstractBranchService
implements BranchSessionService {
    public PageResult<BranchSessionVO> queryByXid(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            return PageResult.success();
        }
        ArrayList<BranchSessionVO> branchSessionVos = new ArrayList<BranchSessionVO>();
        RedisTransactionStoreManager instance = RedisTransactionStoreManagerFactory.getInstance();
        List branchSessionDos = instance.findBranchSessionByXid(xid);
        if (CollectionUtils.isNotEmpty((Collection)branchSessionDos)) {
            for (BranchTransactionDO branchSessionDo : branchSessionDos) {
                BranchSessionVO branchSessionVO = new BranchSessionVO();
                BeanUtils.copyProperties((Object)branchSessionDo, (Object)branchSessionVO);
                branchSessionVos.add(branchSessionVO);
            }
        }
        return PageResult.success(branchSessionVos, (Integer)branchSessionVos.size(), (Integer)0, (Integer)branchSessionVos.size());
    }
}

