/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import net.logstash.logback.marker.LogstashMarker;
import net.logstash.logback.marker.MessageFormatCache;

public abstract class SingleFieldAppendingMarker
extends LogstashMarker
implements StructuredArgument {
    public static final String MARKER_NAME_PREFIX = "LS_APPEND_";
    private final String fieldName;
    private final String messageFormatPattern;

    public SingleFieldAppendingMarker(String markerName, String fieldName) {
        this(markerName, fieldName, "{0}={1}");
    }

    public SingleFieldAppendingMarker(String markerName, String fieldName, String messageFormatPattern) {
        super(markerName);
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName must not be null");
        this.messageFormatPattern = Objects.requireNonNull(messageFormatPattern, "messageFormatPattern must not be null");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        this.writeFieldName(generator);
        this.writeFieldValue(generator);
    }

    protected void writeFieldName(JsonGenerator generator) throws IOException {
        generator.writeFieldName(this.getFieldName());
    }

    protected abstract void writeFieldValue(JsonGenerator var1) throws IOException;

    @Override
    public String toStringSelf() {
        String fieldValueString = StructuredArguments.toString(this.getFieldValue());
        if ("{1}".equals(this.messageFormatPattern)) {
            return fieldValueString;
        }
        if ("{0}={1}".equals(this.messageFormatPattern)) {
            return this.getFieldName() + "=" + fieldValueString;
        }
        return MessageFormatCache.INSTANCE.getMessageFormat(this.messageFormatPattern).format(new Object[]{this.getFieldName(), fieldValueString});
    }

    public abstract Object getFieldValue();

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SingleFieldAppendingMarker)) {
            return false;
        }
        SingleFieldAppendingMarker other = (SingleFieldAppendingMarker)obj;
        return this.fieldName.equals(other.fieldName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }
}

