/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Configuration;
import dm.jdbc.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public class MetaSQL {
    private static final String ESCAPE = " ESCAPE '!' ";
    public static final int TABLE_DB_TYPE_NORMAL = 0;
    public static final int TABLE_DB_TYPE_VERTICAL = 3;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION = 4;
    public static final int TABLE_DB_TYPE_VERTICAL_PARTITION_S = 5;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION = 6;
    public static final int TABLE_DB_TYPE_RANGE_PARTITION_S = 7;
    public static final int TABLE_DB_TYPE_HASH_PARTITION = 8;
    public static final int TABLE_DB_TYPE_HASH_PARTITION_S = 9;
    public static final int TABLE_DB_TYPE_BITMAP_JOIN = 10;
    public static final int TABLE_DB_TYPE_LIST_PARTITION = 11;
    public static final int TABLE_DB_TYPE_LIST_PARTITION_S = 12;
    public static final int TABLE_DB_TYPE_EXTERNAL = 13;
    public static final int TABLE_DB_TYPE_ARR = 14;
    public static final int TABLE_DB_TYPE_REMOTE = 15;
    public static final int TABLE_DB_TYPE_HUGE = 19;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION = 17;
    public static final int TABLE_DB_TYPE_V_RANGE_PARTITION_S = 18;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION = 20;
    public static final int TABLE_DB_TYPE_V_HASH_PARTITION_S = 21;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION = 22;
    public static final int TABLE_DB_TYPE_V_LIST_PARTITION_S = 23;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION = 24;
    public static final int TABLE_DB_TYPE_HUG_RANGE_PARTITION_S = 25;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION = 26;
    public static final int TABLE_DB_TYPE_HUG_HASH_PARTITION_S = 27;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION = 28;
    public static final int TABLE_DB_TYPE_HUG_LIST_PARTITION_S = 29;
    public static final int TABLE_DB_TYPE_BITMAP = 32;
    public static final int TABLE_TEMP_TYPE_NO_TEMP = 0;
    public static final int TABLE_TEMP_TYPE_GLOBAL_TEMP = 1;
    public static final int TABLE_TEMP_TYPE_LOCAL_TEMP = 2;
    private boolean compatibleOracle = false;
    private String currentSchema;

    public MetaSQL(String string, boolean bl) {
        this.compatibleOracle = bl;
        this.currentSchema = StringUtil.isEmpty(string) ? "" : string;
    }

    public String getAttributes(List list, String string, String string2, String string3, String string4) {
        String string5 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS ATTR_NAME,CAST(NULL AS INT) AS DATA_TYPE,CAST(NULL AS VARCHAR(128)) AS ATTR_TYPE_NAME,CAST(NULL AS INT) AS ATTR_SIZE,CAST(NULL AS INT) AS DECIMAL_DIGITS,CAST(NULL AS INT) AS NUM_PREC_RADIX,CAST(NULL AS INT) AS NULLABLE,CAST(NULL AS VARCHAR(128)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,CAST(NULL AS INT) AS SQL_DATA_TYPE,CAST(NULL AS INT) AS SQL_DATETIME_SUB,CAST(NULL AS INT) AS CHAR_OCTET_LENGTH,CAST(NULL AS INT) AS ORDINAL_POSITION,CAST(NULL AS VARCHAR(128)) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM DUAL WHERE 1 = 2";
        return string5;
    }

    public String getTableTypes() {
        String string = "(SELECT 'SYSTEM TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'VIEW' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'GLOBAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'LOCAL TEMPORARY' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION (SELECT 'SYNONYM' AS TABLE_TYPE FROM SYS.SYSDUAL) ";
        return string;
    }

    public String getTypeInfo() {
        String string = "select TYPEINFO.TYPE_NAME, TYPEINFO.DATA_TYPE, TYPEINFO.PRECISION, TYPEINFO.LITERAL_PREFIX, TYPEINFO.LITERAL_SUFFIX, TYPEINFO.CREATE_PARAMS, TYPEINFO.NULLABLE, TYPEINFO.CASE_SENSITIVE, TYPEINFO.SEARCHABLE,TYPEINFO.UNSIGNED_ATTRIBUTE, TYPEINFO.FIXED_PREC_SCALE, TYPEINFO.\"AUTO_INCREMENT\", TYPEINFO.LOCAL_TYPE_NAME, TYPEINFO.MINIMUM_SCALE, TYPEINFO.MAXIMUM_SCALE, TYPEINFO.SQL_DATA_TYPE, TYPEINFO.SQL_DATETIME_SUB, TYPEINFO.NUM_PREC_RADIX from (";
        string = String.valueOf(string) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT TYPE_NAME AS TYPE_NAME,";
        string = String.valueOf(string) + " CASE DATA_TYPE WHEN 101 THEN 2000 WHEN 102 THEN 2000 WHEN 103 THEN 2000 WHEN 104 THEN 2000 WHEN 105 THEN 2000 WHEN 106 THEN 2000 WHEN 107 THEN 2000 WHEN 108 THEN 2000 WHEN 109 THEN 2000 WHEN 110 THEN 2000 WHEN 111 THEN 2000 WHEN 112 THEN 2000 WHEN 113 THEN 2000 ELSE DATA_TYPE END AS DATA_TYPE,";
        string = String.valueOf(string) + " COLUMN_SIZE AS \"PRECISION\",LITERAL_PREFIX AS LITERAL_PREFIX,LITERAL_SUFFIX AS LITERAL_SUFFIX,CREATE_PARAMS AS CREATE_PARAMS,NULLABLE$ AS NULLABLE,CASE_SENSITIVE AS CASE_SENSITIVE,SEARCHABLE AS SEARCHABLE,UNSIGNED_ATTRIBUTE AS UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE AS FIXED_PREC_SCALE,AUTO_UNIQUE_VALUE AS \"AUTO_INCREMENT\",LOCAL_TYPE_NAME AS LOCAL_TYPE_NAME,MINIMUM_SCALE AS MINIMUM_SCALE,MAXIMUM_SCALE AS MAXIMUM_SCALE,NULL AS SQL_DATA_TYPE,NULL AS SQL_DATETIME_SUB,NUM_PREC_RADIX AS NUM_PREC_RADIX";
        string = String.valueOf(string) + " FROM SYS.SYSTYPEINFOS WHERE (TYPE_VERSION = 'O3' OR TYPE_VERSION = 'J3') AND TYPE_NAME <> 'double precision' AND TYPE_NAME <> 'image' AND TYPE_NAME <> 'text' AND TYPE_NAME <> 'money'";
        string = String.valueOf(string) + " ORDER BY DATA_TYPE) TYPEINFO;";
        return string;
    }

    public String getCatalogs() {
        String string = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT FROM SYS.SYSDUAL WHERE 1=2;";
        return string;
    }

    public String getSchemas() {
        String string = "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG ";
        string = String.valueOf(string) + " FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ";
        string = String.valueOf(string) + " ORDER BY TABLE_SCHEM ASC;";
        return string;
    }

    public String getSchemas(List list, String string, String string2) {
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        String string3 = "SELECT DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ";
        if (!MetaSQL.containsEscape(string2)) {
            string3 = String.valueOf(string3) + " AND NAME = ? ";
            list.add(string2);
        } else if (!string2.equals("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
            list.add(string2);
        }
        string3 = String.valueOf(string3) + " ORDER BY TABLE_SCHEM ASC;";
        return string3;
    }

    public String getTables(List list, String string, String string2, String string3, String[] stringArray) {
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,SCHEMAS.NAME AS TABLE_SCHEM,TABS.NAME AS TABLE_NAME, CASE TABS.SUBTYPE$ WHEN 'UTAB' THEN 'TABLE' WHEN 'VIEW' THEN 'VIEW' WHEN 'STAB' THEN 'SYSTEM TABLE' WHEN 'SYNOM' THEN 'SYNONYM' END AS TABLE_TYPE, (SELECT COMMENT$ FROM SYS.SYSTABLECOMMENTS WHERE SCHNAME = SCHEMAS.NAME AND TVNAME = TABS.NAME) AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION ");
        stringBuilder.append(" FROM");
        stringBuilder.append(this.schemaClause(list, string2, "SCHEMAS,"));
        stringBuilder.append(this.tableClause(list, string3, stringArray, "TABS"));
        stringBuilder.append(" WHERE TABS.SCHID = SCHEMAS.ID ");
        stringBuilder.append(" AND (SF_CHECK_PRIV_OPT(UID(), CURRENT_USERTYPE(), TABS.ID, SCHEMAS.PID, -1, TABS.ID) = 1) ");
        stringBuilder.append(" ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;");
        return stringBuilder.toString();
    }

    public String getTablePrivileges(List list, String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        stringBuilder.append("USERS.NAME AS TABLE_SCHEM, ");
        stringBuilder.append("TABS.NAME AS TABLE_NAME,");
        stringBuilder.append("GRANTORS.NAME AS GRANTOR,");
        stringBuilder.append("GRANTEES.NAME AS GRANTEE,");
        stringBuilder.append("SF_GET_SYS_PRIV(CAST (TVGRANTS.PRIVID AS INT)) AS PRIVILEGE,");
        stringBuilder.append("CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaClause(list, string2, "USERS")).append(",");
        stringBuilder.append(this.utableClause(list, string3, "TABS")).append(",");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTORS,");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'UR' AND SUBTYPE$ = 'USER')GRANTEES,");
        stringBuilder.append("(SELECT * FROM SYS.SYSGRANTS WHERE PRIVID <> -1 )TVGRANTS");
        stringBuilder.append(" WHERE");
        stringBuilder.append(" TABS.SCHID = USERS.ID AND ");
        stringBuilder.append(" TVGRANTS.OBJID = TABS.ID AND TVGRANTS.URID = GRANTEES.ID AND ");
        stringBuilder.append(" TVGRANTS.GRANTOR = GRANTORS.ID");
        stringBuilder.append(" ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC;");
        return stringBuilder.toString();
    }

    public String getColumns(List list, String string, String string2, String string3, String string4) {
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        string4 = string4 == null ? "%" : string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("NULL AS TABLE_CAT, ");
        stringBuilder.append("SCHS.NAME AS TABLE_SCHEM, ");
        stringBuilder.append("TABS.NAME AS TABLE_NAME, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append(this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE"));
        stringBuilder.append("AS DATA_TYPE,");
        stringBuilder.append(this.makeDataTypeNameClause("COLS.TYPE$"));
        stringBuilder.append("AS TYPE_NAME,");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS COLUMN_SIZE,");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS BUFFER_LENGTH,");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END ");
        stringBuilder.append("AS DECIMAL_DIGITS,");
        stringBuilder.append("10 AS NUM_PREC_RADIX,");
        stringBuilder.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,");
        stringBuilder.append("(SELECT COMMENT$ FROM SYS.SYSCOLUMNCOMMENTS WHERE SCHNAME=SCHS.NAME AND TVNAME=TABS.NAME AND COLNAME=COLS.NAME) AS REMARKS,");
        stringBuilder.append("COLS.DEFVAL AS COLUMN_DEF,");
        stringBuilder.append("0 AS SQL_DATA_TYPE,");
        stringBuilder.append("0 AS SQL_DATETIME_SUB,");
        stringBuilder.append("CASE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ").append("ELSE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) END ").append("AS CHAR_OCTET_LENGTH,");
        stringBuilder.append("COLS.COLID + 1 AS ORDINAL_POSITION,");
        stringBuilder.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,");
        stringBuilder.append("NULL AS SCOPE_CATALOG,");
        stringBuilder.append("NULL AS SCOPE_SCHEMA,");
        stringBuilder.append("NULL AS SCOPE_TABLE,");
        stringBuilder.append("0 AS SOURCE_DATA_TYPE, ");
        stringBuilder.append("CASE COLS.INFO2 & 0x01 WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_AUTOINCREMENT, ");
        stringBuilder.append("CASE (select INFO1 & 0x01 from SYS.SYSCOLINFOS where ID = COLS.ID and COLID = COLS.COLID) WHEN 1 THEN 'YES' ELSE 'NO' END AS IS_GENERATEDCOLUMN ");
        stringBuilder.append("FROM ");
        stringBuilder.append(this.schemaClause(list, string2, "SCHS"));
        stringBuilder.append(", ");
        stringBuilder.append(this.tableClause(list, string3, "TABS"));
        stringBuilder.append(", ");
        stringBuilder.append(this.argClause(list, string4, "COLS"));
        stringBuilder.append(" WHERE TABS.ID = COLS.ID AND SCHS.ID = TABS.SCHID ");
        stringBuilder.append(" ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;");
        return stringBuilder.toString();
    }

    public String getColumnPrivileges(List list, String string, String string2, String string3, String string4) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        string4 = string4 == null ? "%" : string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        stringBuilder.append("TABS.NAME AS TABLE_NAME, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append("GRANTORS.NAME AS GRANTOR,");
        stringBuilder.append("GRANTEES.NAME AS GRANTEE,");
        stringBuilder.append("SF_GET_SYS_PRIV(CAST (COLGRANTS.PRIVID AS INT)) AS PRIVILEGE, ");
        stringBuilder.append("CASE COLGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE ");
        stringBuilder.append("FROM SYS.SYSGRANTS COLGRANTS, ");
        stringBuilder.append(this.argClause(list, string4, "COLS")).append(",");
        stringBuilder.append("SYS.SYSOBJECTS GRANTORS, ");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='USER' OR SUBTYPE$='ROLE') GRANTEES,");
        stringBuilder.append(this.schemaEqualClause(list, string2, "SCHEMAS")).append(",");
        stringBuilder.append(this.utableEqualClause(list, string3, "TABS"));
        stringBuilder.append(" WHERE TABS.SCHID = SCHEMAS.ID");
        stringBuilder.append(" AND COLGRANTS.OBJID = TABS.ID ");
        stringBuilder.append(" AND COLGRANTS.GRANTOR = GRANTORS.ID AND COLGRANTS.URID = GRANTEES.ID AND ");
        stringBuilder.append("COLGRANTS.COLID = COLS.COLID AND COLGRANTS.OBJID = COLS.ID");
        stringBuilder.append(" ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;");
        return stringBuilder.toString();
    }

    public String getPkgProcedures(List list, String string, String string2, String string3, int n2) {
        string = string == null ? "%" : string;
        string2 = string2 == null ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PKGPROCS.MTDNAME AS PROCEDURE_NAME,");
        stringBuilder.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, CASE PKGPROCS.IS_PROC WHEN 'Y' THEN 1 ELSE  2 END AS PROCEDURE_TYPE");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaClause(list, string, "SCHEMAS,"));
        stringBuilder.append(this.pkgClause(list, string2, "PACKAGES,"));
        stringBuilder.append(this.pkgprocClause(list, string2, string3, n2, "PKGPROCS"));
        stringBuilder.append(" WHERE PKGPROCS.PKGID = PACKAGES.ID AND PACKAGES.SCHID = SCHEMAS.ID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC;");
        return stringBuilder.toString();
    }

    public String getPrimaryKeys(List list, String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS TABLE_SCHEM,");
        stringBuilder.append("TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS KEY_SEQ,");
        if (this.compatibleOracle) {
            stringBuilder.append(" OBJ_INDS.NAME AS PK_NAME, ");
        } else {
            stringBuilder.append(" CONS.NAME AS PK_NAME, ");
        }
        stringBuilder.append(" COLS.ID TABID, COLS.COLID COLID ");
        stringBuilder.append(" FROM");
        stringBuilder.append(" SYS.SYSINDEXES INDS,");
        stringBuilder.append("(SELECT OBJ.NAME, CON.ID, CON.TYPE$, CON.TABLEID, CON.COLID, CON.INDEXID FROM SYS.SYSCONS AS CON, SYS.SYSOBJECTS AS OBJ WHERE CON.TYPE$ = 'P' AND OBJ.SUBTYPE$='CONS' AND OBJ.ID=CON.ID) CONS,");
        stringBuilder.append("SYS.SYSCOLUMNS COLS,");
        stringBuilder.append(this.schemaEqualClause(list, string2, "SCHEMAS")).append(",");
        stringBuilder.append(this.utableEqualClause(list, string3, "TAB")).append(",");
        stringBuilder.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')OBJ_INDS");
        stringBuilder.append(" WHERE SCHEMAS.ID = TAB.SCHID AND CONS.INDEXID=INDS.ID AND INDS.ID=OBJ_INDS.ID AND TAB.ID=COLS.ID AND CONS.TABLEID=TAB.ID AND SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO,COLS.COLID)=1");
        stringBuilder.append("ORDER BY COLUMN_NAME ASC");
        return stringBuilder.toString();
    }

    public String getBestRowIdentifier(List list, List list2, List list3, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = StringUtil.join(list2.toArray(), ", ");
        String string2 = StringUtil.join(list3.toArray(), ", ");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ '").append(n2).append("' as \"SCOPE\",COLS.NAME AS COLUMN_NAME,").append(this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE")).append("AS DATA_TYPE, ").append(this.makeDataTypeNameClause("COLS.TYPE$")).append("AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN");
        stringBuilder.append(" FROM SYS.SYSCOLUMNS COLS where COLS.ID in ( " + string + ") AND COLS.COLID in ( " + string2 + ")");
        return stringBuilder.toString();
    }

    public String getBestRowIdentifier(List list, String string, String string2, String string3, int n2, boolean bl) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select /*+ MAX_OPT_N_TABLES(5) */ '").append(n2).append("' as \"SCOPE\",'ROWID' as COLUMN_NAME,-2 as DATA_TYPE,'LONG' as TYPE_NAME,8 as COLUMN_SIZE,8 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,0 as PSEUDO_COLUMN");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaEqualClause(list, string2, "SCHEMAS")).append(",");
        stringBuilder.append(this.utableEqualClause(list, string3, "TAB"));
        stringBuilder.append(" WHERE SCHEMAS.ID = TAB.SCHID ");
        return stringBuilder.toString();
    }

    public String getImportedKeys(List list, String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        String string4 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM, T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM (SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REF_CONS, (SELECT TABS.NAME AS NAME, TABS.ID, SCHEMAS.NAME AS SCHNAME FROM" + this.schemaEqualClause(list, string2, "SCHEMAS") + "," + this.utableEqualClause(list, string3, "TABS") + " WHERE SCHEMAS.ID == TABS.SCHID)T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_IND, " + "(SELECT ID, PID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL " + "WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_CONS.INDEXID AS REFED_ID, T_REFED_TAB.SCH_NAME AS SCHNAME, " + "T_REFED_TAB.TAB_NAME AS NAME, T_REFED_IND.ID AS REFED_IND_ID, " + "T_REFED_CONS.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, " + "T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "(SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REFED_CONS, " + "(SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM " + "SYS.SYSOBJECTS TAB, " + "SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID" + " AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + "WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO " + "ORDER BY FKTABLE_CAT ASC, FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        return string4;
    }

    public String getExportedKeys(List list, String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        String string4 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, T_REF.REF_SCH_NAME AS FKTABLE_SCHEM, T_REF.REF_TAB_NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REF.REF_CONS_ID) AS FK_NAME, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REFED.REFED_CONS_ID) AS PK_NAME, 0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.SCH_NAME AS REF_SCH_NAME, T_REF_TAB.TAB_NAME AS REF_TAB_NAME, T_REF_CONS.ID AS REF_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS, (SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM SYS.SYSOBJECTS TAB, SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REF_TAB, SYS.SYSINDEXES AS T_REF_IND,(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, SYS.SYSCOLUMNS AS T_REF_COL WHERE T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, (SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_CONS.ID AS REFED_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, T_REFED_COL.NAME AS REFED_COL_NAME, T_REFED_CONS.INDEXID AS REFED_ID FROM SYS.SYSCONS AS T_REFED_CONS, (SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME  FROM " + this.schemaEqualClause(list, string2, "SCHEMAS") + "," + this.utableEqualClause(list, string3, "TABS") + " WHERE TABS.SCHID = SCHEMAS.ID" + ") AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_IND, " + "(SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED " + " WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND " + "T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC, " + "FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC";
        return string4;
    }

    public String getCrossReference(List list, String string, String string2, String string3, String string4, String string5, String string6) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "" : string3;
        string5 = StringUtil.isEmpty(string5) ? this.currentSchema : string5;
        string6 = string6 == null ? "" : string6;
        String string7 = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,T_REFED.SCHNAME AS PKTABLE_SCHEM,T_REFED.NAME AS PKTABLE_NAME,T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT,T_REF.SCHNAME AS FKTABLE_SCHEM,T_REF.NAME AS FKTABLE_NAME,T_REF.REF_COL_NAME AS FKCOLUMN_NAME,T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(FACTION) AS DELETE_RULE,T_REF.REF_CONS_NAME AS FK_NAME,T_REFED.REFED_CONS_NAME AS PK_NAME,0 AS DEFERRABILITY FROM (SELECT T_REF_TAB.NAME AS NAME, T_REF_TAB.SCHNAME AS SCHNAME, T_REF_CONS.FINDEXID AS REFED_IND_ID,T_REF_INDS_OBJ.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO,T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS,(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM" + this.schemaEqualClause(list, string5, "SCHEMAS") + "," + this.utableEqualClause(list, string6, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID)AS T_REF_TAB," + "SYS.SYSINDEXES AS T_REF_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_INDS.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, " + "(SELECT T_REFED_TAB.NAME AS NAME, T_REFED_TAB.SCHNAME AS SCHNAME, T_REFED_INDS.ID AS REFED_IND_ID,T_REFED_INDS_OBJ.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO,T_REFED_COL.NAME AS REFED_COL_NAME FROM " + "SYS.SYSCONS AS T_REFED_CONS," + "(SELECT TABS.NAME AS NAME, TABS.ID AS ID, SCHEMAS.NAME AS SCHNAME FROM " + this.schemaEqualClause(list, string2, "SCHEMAS") + "," + this.utableEqualClause(list, string3, "TABS") + " WHERE SCHEMAS.ID = TABS.SCHID) AS T_REFED_TAB," + "SYS.SYSINDEXES AS T_REFED_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ," + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_INDS.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED" + " WHERE T_REF.REFED_IND_ID = T_REFED.REFED_IND_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC,FKTABLE_SCHEM ASC,FKTABLE_NAME ASC,KEY_SEQ ASC";
        return string7;
    }

    public String getIndexInfo(List list, String string, String string2, String string3, boolean bl, boolean bl2) {
        string2 = StringUtil.isEmpty(string2) ? this.currentSchema : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL");
        stringBuilder.append(" AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ");
        stringBuilder.append("CASE INDS.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ");
        stringBuilder.append("OBJ_INDS.NAME AS INDEX_NAME, ");
        stringBuilder.append("CASE INDS.XTYPE & 0x01 WHEN 0 THEN 1 ");
        stringBuilder.append("ELSE 3 END AS \"TYPE\", ");
        stringBuilder.append("SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ORDINAL_POSITION, ");
        stringBuilder.append("COLS.NAME AS COLUMN_NAME, ");
        stringBuilder.append("SF_GET_INDEX_KEY_ORDER(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ASC_OR_DESC, ");
        stringBuilder.append("0 AS CARDINALITY, 0 AS PAGES, NULL AS FILTER_CONDITION ");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaEqualClause(list, string2, "USERS")).append(",");
        stringBuilder.append(this.utableEqualClause(list, string3, "TAB")).append(",");
        stringBuilder.append("(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS OBJ_INDS,");
        stringBuilder.append("SYS.SYSINDEXES AS INDS,");
        stringBuilder.append("SYS.SYSCOLUMNS AS COLS ");
        stringBuilder.append("WHERE TAB.ID=COLS.ID AND TAB.ID=OBJ_INDS.PID ");
        stringBuilder.append("AND INDS.ID=OBJ_INDS.ID AND TAB.SCHID = USERS.ID AND ");
        stringBuilder.append("SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID)=1");
        if (bl) {
            stringBuilder.append(" AND INDS.ISUNIQUE = 'Y' ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        } else {
            stringBuilder.append(" ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        }
        return stringBuilder.toString();
    }

    public String getUDTs(List list, String string, String string2, String string3, int[] nArray) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS CLASS_NAME, CAST(NULL AS INT) AS DATA_TYPE, CAST(NULL AS VARCHAR(1024)) AS REMARKS, CAST(NULL AS SMALLINT) AS BASE_TYPE FROM DUAL WHERE 1 = 2";
        return string4;
    }

    public String getSuperTypes(List list, String string, String string2, String string3) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT, CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM, CAST(NULL AS VARCHAR(128)) AS TYPE_NAME, CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_NAME FROM DUAL WHERE 1 = 2";
        return string4;
    }

    public String getSuperTables(List list, String string, String string2, String string3) {
        String string4 = "SELECT CAST(NULL AS VARCHAR(128))  AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,CAST(NULL AS VARCHAR(128)) AS TABLE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTABLE_NAME FROM DUAL WHERE 1 = 2";
        return string4;
    }

    public String getProcedureColumns(List list, String string, String string2, String string3, String string4) {
        if (this.compatibleOracle && StringUtil.isNotEmpty(string)) {
            return this.getPkgProcedureColumns(list, string2, string, string3, string4, 0);
        }
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        string4 = string4 == null ? "%" : string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("NULL AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.NAME AS PROCEDURE_NAME,");
        if (this.compatibleOracle) {
            stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            stringBuilder.append("ARG.NAME AS COLUMN_NAME,");
        }
        stringBuilder.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 4 WHEN 2 THEN 2 WHEN 3 THEN 5 END AS COLUMN_TYPE, ");
        stringBuilder.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        stringBuilder.append("AS DATA_TYPE, ");
        stringBuilder.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        stringBuilder.append("AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS \"PRECISION\", ");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS LENGTH, ");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS SCALE, ");
        stringBuilder.append("10 AS RADIX, ");
        stringBuilder.append("1 AS NULLABLE, ");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("ARG.DEFVAL AS COLUMN_DEF, ");
        stringBuilder.append("NULL AS SQL_DATA_TYPE, ");
        stringBuilder.append("NULL AS SQL_DATETIME_SUB, ");
        stringBuilder.append("NULL AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("ARG.COLID AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("NULL AS SPECIFIC_NAME ");
        stringBuilder.append("FROM ");
        stringBuilder.append(this.schemaClause(list, string2, "SCHEMAS")).append(",");
        stringBuilder.append(MetaSQL.procClause(list, string3, "PROCS", this.compatibleOracle)).append(",");
        stringBuilder.append(this.argClause(list, string4, "ARG"));
        stringBuilder.append(" WHERE SCHEMAS.ID = PROCS.SCHID AND PROCS.ID = ARG.ID ");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return stringBuilder.toString();
    }

    public String getFunctionColumns(List list, String string, String string2, String string3, String string4) {
        if (this.compatibleOracle && StringUtil.isNotEmpty(string)) {
            return this.getPkgProcedureColumns(list, string2, string, string3, string4, 2);
        }
        string = string == null ? string : string.trim();
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        string4 = string4 == null ? "%" : string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT ");
        if (string == null) {
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append("'").append(string).append("'");
        }
        stringBuilder.append(" AS FUNCTION_CAT,");
        stringBuilder.append("USERS.NAME AS FUNCTION_SCHEM,");
        stringBuilder.append("FUNCS.NAME AS FUNCTION_NAME,");
        if (this.compatibleOracle) {
            stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            stringBuilder.append("ARG.NAME AS COLUMN_NAME,");
        }
        stringBuilder.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 3 WHEN 2 THEN 2 WHEN 3 THEN 4 END AS COLUMN_TYPE,");
        stringBuilder.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        stringBuilder.append("AS DATA_TYPE,");
        stringBuilder.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        stringBuilder.append("AS TYPE_NAME,");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END AS SCALE,");
        stringBuilder.append("10 AS RADIX,");
        stringBuilder.append("1 AS NULLABLE,");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("CASE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) END AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("CASE ARG.INFO1 WHEN 3 THEN 0 ELSE ARG.COLID + 1 END AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("FUNCS.NAME AS SPECIFIC_NAME, ");
        stringBuilder.append("ARG.COLID ");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaClause(list, string2, "USERS")).append(",");
        stringBuilder.append(MetaSQL.funcClause(list, string3, "FUNCS")).append(",");
        stringBuilder.append(this.argClause(list, string4, "ARG"));
        stringBuilder.append(" WHERE USERS.ID = FUNCS.SCHID AND FUNCS.ID = ARG.ID");
        stringBuilder.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC, ARG.COLID ASC;");
        return stringBuilder.toString();
    }

    public String getClientInfoProperties() {
        StringBuilder stringBuilder = new StringBuilder("declare \ntype RowVal is record (NAME varchar, MAX_LEN int, DEFAULT_VALUE varchar, DESCRIPTION varchar); \ntype RowVals is array RowVal[];\nr RowVal; \nrs RowVals;\n");
        stringBuilder.append("begin \n");
        stringBuilder.append("rs = new RowVal[").append(Configuration.values().size()).append("]; \n");
        int n2 = 1;
        for (Configuration configuration : Configuration.values()) {
            stringBuilder.append("r.name = '").append(configuration.getName()).append("';\n");
            stringBuilder.append("r.max_len = 128;\n");
            stringBuilder.append("r.default_value = '").append(configuration.getDefault()).append("';\n");
            stringBuilder.append("r.description = '").append(StringUtil.processSingleQuoteOfName(configuration.getDescription())).append("';\n");
            stringBuilder.append("rs[").append(n2).append("] = r;\n");
            ++n2;
        }
        stringBuilder.append("select * from array rs;\n");
        stringBuilder.append("end;");
        return stringBuilder.toString();
    }

    public String getVersionColumns(List list, String string, String string2, String string3) {
        String string4 = "";
        string4 = String.valueOf(string4) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS \"SCOPE\",COLS.NAME AS COLUMN_NAME, ";
        string4 = String.valueOf(string4) + this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE") + "AS DATA_TYPE, ";
        string4 = String.valueOf(string4) + this.makeDataTypeNameClause("COLS.TYPE$") + "AS TYPE_NAME, ";
        string4 = String.valueOf(string4) + "CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
        string4 = String.valueOf(string4) + " FROM SYS.SYSCOLUMNS COLS WHERE 1 = 2;";
        return string4;
    }

    public String getProcedures(List list, String string, String string2, String string3) {
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.NAME AS PROCEDURE_NAME,");
        stringBuilder.append("'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, 1 AS PROCEDURE_TYPE, ");
        stringBuilder.append("NULL AS SPECIFIC_NAME ");
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.schemaClause(list, string2, "SCHEMAS")).append(",");
        stringBuilder.append(MetaSQL.procClause(list, string3, "PROCS", this.compatibleOracle));
        stringBuilder.append(" WHERE SCHEMAS.ID = PROCS.SCHID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        return stringBuilder.toString();
    }

    public String getFunctions(List list, String string, String string2, String string3) {
        string = string == null ? string : string.trim();
        string2 = StringUtil.isEmpty(string2) ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT DISTINCT ");
        if (string == null) {
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append(" ? ");
            list.add(string);
        }
        stringBuilder.append(" AS FUNCTION_CAT, SCHEMAS.NAME AS FUNCTION_SCHEM, FUNCS.NAME AS FUNCTION_NAME, NULL AS REMARKS, 2 AS FUNCTION_TYPE, FUNCS.NAME AS SPECIFIC_NAME");
        stringBuilder.append(" FROM ");
        stringBuilder.append(MetaSQL.funcClause(list, string3, "FUNCS")).append(",");
        stringBuilder.append(this.schemaClause(list, string2, "SCHEMAS"));
        stringBuilder.append(" WHERE SCHEMAS.ID = FUNCS.SCHID");
        stringBuilder.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC;");
        return stringBuilder.toString();
    }

    private String getPkgProcedureColumns(List list, String string, String string2, String string3, String string4, int n2) {
        string = string == null ? "%" : string;
        string2 = string2 == null ? "%" : string2;
        string3 = string3 == null ? "%" : string3;
        string4 = string4 == null ? "%" : string4;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        stringBuilder.append("PACKAGES.NAME AS PROCEDURE_CAT,");
        stringBuilder.append("SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        stringBuilder.append("PROCS.MTDNAME AS PROCEDURE_NAME,");
        stringBuilder.append("CASE TRIM(ARG.IOFLAG) WHEN 'R' THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        stringBuilder.append("CASE TRIM(ARG.IOFLAG)");
        stringBuilder.append(" WHEN 'I' THEN 1");
        stringBuilder.append(" WHEN 'O' THEN 4");
        stringBuilder.append(" WHEN 'IO' THEN 2");
        stringBuilder.append(" WHEN 'R' THEN 5");
        stringBuilder.append(" END AS COLUMN_TYPE, ");
        stringBuilder.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        stringBuilder.append("AS DATA_TYPE, ");
        stringBuilder.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        stringBuilder.append("AS TYPE_NAME, ");
        stringBuilder.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS \"PRECISION\", ");
        stringBuilder.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS LENGTH, ");
        stringBuilder.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        stringBuilder.append("WHEN -2 THEN NULL ");
        stringBuilder.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        stringBuilder.append("AS SCALE, ");
        stringBuilder.append("10 AS RADIX, ");
        stringBuilder.append("1 AS NULLABLE, ");
        stringBuilder.append("NULL AS REMARKS, ");
        stringBuilder.append("ARG.DEFVAL AS COLUMN_DEF, ");
        stringBuilder.append("NULL AS SQL_DATA_TYPE, ");
        stringBuilder.append("NULL AS SQL_DATETIME_SUB, ");
        stringBuilder.append("NULL AS CHAR_OCTET_LENGTH, ");
        stringBuilder.append("ARG.PARAMID AS ORDINAL_POSITION, ");
        stringBuilder.append("CASE ARG.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        stringBuilder.append("NULL AS SPECIFIC_NAME ");
        stringBuilder.append("FROM");
        stringBuilder.append(this.schemaClause(list, string, "SCHEMAS")).append(",");
        stringBuilder.append(this.pkgClause(list, string2, "PACKAGES")).append(",");
        stringBuilder.append(this.pkgprocClause(list, string2, string3, n2, "PROCS")).append(",");
        stringBuilder.append(this.pkgprocargClause(list, string4, "ARG"));
        stringBuilder.append(" WHERE");
        stringBuilder.append(" PROCS.PKGID = PACKAGES.ID");
        stringBuilder.append(" AND PACKAGES.SCHID = SCHEMAS.ID");
        stringBuilder.append(" AND ARG.PKGID = PROCS.PKGID");
        stringBuilder.append(" AND ARG.MTDID = PROCS.MTDID");
        stringBuilder.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return stringBuilder.toString();
    }

    private String makeDataTypeClause(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CASE ").append(string);
        stringBuilder.append(" WHEN 'BOOL' THEN 16");
        stringBuilder.append(" WHEN 'BOOLEAN' THEN 16");
        stringBuilder.append(" WHEN 'BIT' THEN -7");
        stringBuilder.append(" WHEN 'NUMBER' THEN 3");
        stringBuilder.append(" WHEN 'NUMERIC' THEN 3");
        stringBuilder.append(" WHEN 'DEC' THEN 3");
        stringBuilder.append(" WHEN 'DECIMAL' THEN 3");
        if (this.compatibleOracle) {
            stringBuilder.append(" WHEN 'INT' THEN 3");
            stringBuilder.append(" WHEN 'INTEGER' THEN 3");
            stringBuilder.append(" WHEN 'BIGINT' THEN 3");
            stringBuilder.append(" WHEN 'TINYINT' THEN 3");
            stringBuilder.append(" WHEN 'SMALLINT' THEN 3");
        } else {
            stringBuilder.append(" WHEN 'INT' THEN 4");
            stringBuilder.append(" WHEN 'INTEGER' THEN 4");
            stringBuilder.append(" WHEN 'BIGINT' THEN -5");
            stringBuilder.append(" WHEN 'TINYINT' THEN -6");
            stringBuilder.append(" WHEN 'SMALLINT' THEN 5");
        }
        stringBuilder.append(" WHEN 'FLOAT' THEN 6");
        stringBuilder.append(" WHEN 'DOUBLE' THEN 8");
        stringBuilder.append(" WHEN 'REAL' THEN 7");
        stringBuilder.append(" WHEN 'DOUBLE PRECISION' THEN 8");
        stringBuilder.append(" WHEN 'CHARACTER' THEN 1");
        stringBuilder.append(" WHEN 'VARCHAR' THEN 12");
        stringBuilder.append(" WHEN 'VARCHAR2' THEN 12");
        stringBuilder.append(" WHEN 'TEXT' THEN -1");
        stringBuilder.append(" WHEN 'LONGVARCHAR' THEN -1");
        stringBuilder.append(" WHEN 'CLOB' THEN 2005");
        stringBuilder.append(" WHEN 'BYTE' THEN -6");
        stringBuilder.append(" WHEN 'BINARY' THEN -2");
        stringBuilder.append(" WHEN 'VARBINARY' THEN -3");
        stringBuilder.append(" WHEN 'LONGVARBINARY' THEN -4");
        stringBuilder.append(" WHEN 'BLOB' THEN 2004");
        stringBuilder.append(" WHEN 'IMAGE' THEN -4");
        stringBuilder.append(" WHEN 'TIMESTAMP' THEN 93");
        stringBuilder.append(" WHEN 'DATE' THEN 91");
        stringBuilder.append(" WHEN 'TIME' THEN 92");
        stringBuilder.append(" WHEN 'DATETIME' THEN 93");
        stringBuilder.append(" WHEN 'CURSOR' THEN -10");
        stringBuilder.append(" ELSE SF_GET_DATA_TYPE(").append(string).append(", CAST(").append(string2).append(" AS INT), 3)");
        stringBuilder.append(" END ");
        return stringBuilder.toString();
    }

    private String makeDataTypeNameClause(String string) {
        if (this.compatibleOracle) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CASE ");
            stringBuilder.append("(CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END)  ");
            stringBuilder.append("WHEN 'INT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'INTEGER' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'BIGINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'TINYINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'SMALLINT' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'NUMERIC' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'DEC' THEN 'NUMBER' ");
            stringBuilder.append("WHEN 'DECIMAL' THEN 'NUMBER' ");
            stringBuilder.append("ELSE ");
            stringBuilder.append("(CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END)  ");
            stringBuilder.append("END ");
            return stringBuilder.toString();
        }
        return "CASE INSTR(" + string + ",'CLASS',1,1) WHEN 0 THEN " + string + " ELSE SF_GET_CLASS_NAME(" + string + ") END ";
    }

    private String makeTableTypeClause(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "(";
        String string2 = "CAST((INFO3 & 0x00FF & 0x003F) AS INT) not in ( 9, 27, 29, 25, 12,7, 21, 23, 18, 5) ";
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                if (string3 != null) {
                    if (string3.equalsIgnoreCase("TABLE")) {
                        stringBuilder.append("OR (SUBTYPE$='UTAB' AND ").append(string2).append(")");
                    } else if (string3.equalsIgnoreCase("VIEW")) {
                        stringBuilder.append("OR SUBTYPE$='VIEW' ");
                    } else if (string3.equalsIgnoreCase("SYSTEM TABLE")) {
                        stringBuilder.append("OR SUBTYPE$='STAB' ");
                    } else if (string3.equalsIgnoreCase("SYNONYM")) {
                        stringBuilder.append("OR SUBTYPE$='SYNOM' ");
                    } else if (string3.equalsIgnoreCase("GLOBAL TEMPORARY")) {
                        stringBuilder.append("OR ((info3 & 0x40) >> 6) =1 ");
                    } else if (string3.equalsIgnoreCase("LOCAL TEMPORARY")) {
                        stringBuilder.append("OR ((info3 & 0x40) >> 6) =2 ");
                    }
                }
                ++n3;
            }
            if (stringBuilder.length() > 3) {
                string = String.valueOf(string) + stringBuilder.substring(3);
                string = String.valueOf(string) + ")";
                return string;
            }
        } else {
            stringBuilder.append("( ");
            stringBuilder.append("(SUBTYPE$='UTAB' AND ").append(string2).append(") ");
            stringBuilder.append("OR SUBTYPE$ in ('STAB', 'VIEW', 'SYNOM') ");
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return null;
    }

    private String schemaClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH'";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = ?";
            list.add(string);
        } else if (!string.equals("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + ") " + string2;
        return string3;
    }

    private String schemaEqualClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH' AND NAME = ?) " + string2;
        list.add(string);
        return string3;
    }

    private String pkgClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PKG'";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = ? ";
            list.add(string);
        } else if (!string.equals("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String pkgprocClause(List list, String string, String string2, int n2, String string3) {
        String string4 = "(SELECT PKGID, MTDID, IS_PROC, MTDNAME FROM SYS.V$PKGPROCS ";
        if (!MetaSQL.containsEscape(string)) {
            string4 = String.valueOf(string4) + " WHERE PKGNAME = ? ";
            list.add(string);
        } else if (!string.equals("%")) {
            string4 = String.valueOf(string4) + " WHERE PKGNAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        if (!string2.equals("%")) {
            string4 = String.valueOf(string4) + (string.equals("%") ? " WHERE" : " AND");
            if (!MetaSQL.containsEscape(string2)) {
                string4 = String.valueOf(string4) + " MTDNAME = ? ";
                list.add(string2);
            } else if (!string2.equals("%")) {
                string4 = String.valueOf(string4) + " MTDNAME LIKE ?  ESCAPE '!' ";
                list.add(string2);
            }
        }
        if (n2 == 1 || n2 == 2) {
            string4 = String.valueOf(string4) + (string2.equals("%") ? " WHERE" : " AND");
            if (n2 == 1) {
                string4 = String.valueOf(string4) + " IS_PROC = 'Y'";
            } else if (n2 == 2) {
                string4 = String.valueOf(string4) + " IS_PROC = 'N'";
            }
        }
        string4 = String.valueOf(string4) + ")" + string3;
        return string4;
    }

    private String argClause(List list, String string, String string2) {
        String string3 = "(SELECT A.NAME AS NAME, A.ID AS ID,A.COLID AS COLID, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.TYPE$ WHEN (B.INFO2 & 0xFF) = 0 THEN 'NUMBER' ELSE 'FLOAT' END AS TYPE$, CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.LENGTH$ ELSE (B.INFO2 & 0xFF) END AS LENGTH$,CASE WHEN B.INFO1 IS NULL OR ((B.INFO1>>2) & 0x01)=0 THEN A.SCALE WHEN (B.INFO2 & 0xFF) = 0 THEN 0 ELSE 129 END AS SCALE,A.NULLABLE$ AS NULLABLE$,A.DEFVAL AS DEFVAL,A.INFO1 AS INFO1,A.INFO2 AS INFO2 FROM SYS.SYSCOLUMNS A LEFT JOIN SYS.SYSCOLINFOS B ON A.ID = B.ID AND A.COLID = B.COLID ";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " WHERE NAME = ? ";
            list.add(string);
        } else if (!string.equals("%")) {
            string3 = String.valueOf(string3) + " WHERE NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String pkgprocargClause(List list, String string, String string2) {
        String string3 = "(SELECT *  FROM SYS.V$PKGPROCPARAMS";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " WHERE NAME = ? ";
            list.add(string);
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " WHERE NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String tableClause(List list, String string, String[] stringArray, String string2) {
        String string3 = "(SELECT ID, SCHID, SUBTYPE$, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW', 'SYNOM')";
        String string4 = this.makeTableTypeClause(stringArray);
        if (string4 != null) {
            string3 = String.valueOf(string3) + " AND " + string4;
        }
        if (!string.equals("%")) {
            if (!MetaSQL.containsEscape(string)) {
                string3 = String.valueOf(string3) + " AND NAME = ? ";
                list.add(string);
            } else {
                string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
                list.add(string);
            }
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String tableClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN ('UTAB', 'STAB', 'VIEW')";
        if (!string.equals("%")) {
            if (!MetaSQL.containsEscape(string)) {
                string3 = String.valueOf(string3) + "AND NAME = ? ";
                list.add(string);
            } else {
                string3 = String.valueOf(string3) + "AND NAME LIKE ?  ESCAPE '!' ";
                list.add(string);
            }
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String utableClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB'";
        if (!string.equals("%")) {
            if (!MetaSQL.containsEscape(string)) {
                string3 = String.valueOf(string3) + "AND NAME = ?";
                list.add(string);
            } else {
                string3 = String.valueOf(string3) + "AND NAME LIKE ?  ESCAPE '!' ";
                list.add(string);
            }
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private String utableEqualClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB' AND NAME = ?) " + string2;
        list.add(string);
        return string3;
    }

    private static String procClause(List list, String string, String string2, boolean bl) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = ? ";
            list.add(string);
        } else if (!string.equals("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static String funcClause(List list, String string, String string2) {
        String string3 = "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC'";
        if (!MetaSQL.containsEscape(string)) {
            string3 = String.valueOf(string3) + " AND NAME = ? ";
            list.add(string);
        } else if (!string.equalsIgnoreCase("%")) {
            string3 = String.valueOf(string3) + " AND NAME LIKE ?  ESCAPE '!' ";
            list.add(string);
        }
        string3 = String.valueOf(string3) + " AND INFO1&0X01 = 0";
        string3 = String.valueOf(string3) + ")" + string2;
        return string3;
    }

    private static boolean containsEscape(String string) {
        int n2 = string.length();
        boolean bl = false;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (string.charAt(n3) == '%' || string.charAt(n3) == '_') {
                bl = true;
            }
            --n3;
        }
        return bl;
    }

    public static String gatewayFormat(Object object) {
        if (object == null) {
            return "null";
        }
        String string = "";
        string = object instanceof String ? (String)object : (object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : (object instanceof String[] ? Arrays.toString((String[])object) : object.toString()));
        return "'" + string + "'";
    }
}

