/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthBuildFixedConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandlerBase;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarNotFoundHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.smallrye.health.SmallRyeHealthReporter;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

@Recorder
public class SmallRyeHealthRecorder {
    private final SmallRyeHealthBuildFixedConfig buildFixedConfig;
    private final RuntimeValue<SmallRyeHealthRuntimeConfig> runtimeConfig;

    public SmallRyeHealthRecorder(SmallRyeHealthBuildFixedConfig buildFixedConfig, RuntimeValue<SmallRyeHealthRuntimeConfig> runtimeConfig) {
        this.buildFixedConfig = buildFixedConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public void registerHealthCheckResponseProvider(Class<? extends HealthCheckResponseProvider> providerClass) {
        try {
            HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate service " + String.valueOf(providerClass) + " using the no-arg constructor.");
        }
    }

    public Handler<RoutingContext> uiHandler(String healthUiFinalDestination, String healthUiPath, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        if (((SmallRyeHealthRuntimeConfig)this.runtimeConfig.getValue()).enable()) {
            WebJarStaticHandler handler = new WebJarStaticHandler(healthUiFinalDestination, healthUiPath, webRootConfigurations);
            shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
            return handler;
        }
        return new WebJarNotFoundHandler();
    }

    public void processSmallRyeHealthRuntimeConfiguration() {
        SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)Arc.container().select(SmallRyeHealthReporter.class, new Annotation[0]).get();
        reporter.setAdditionalProperties(((SmallRyeHealthRuntimeConfig)this.runtimeConfig.getValue()).additionalProperties());
        reporter.setHealthChecksConfigs(((SmallRyeHealthRuntimeConfig)this.runtimeConfig.getValue()).check().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SmallRyeHealthRuntimeConfig.Enabled)e.getValue()).enabled())));
        SmallRyeHealthHandlerBase.problemDetails = this.buildFixedConfig.includeProblemDetails();
    }
}

