/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.bootstrap;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.core.persistence.bootstrap.RootCredentials;
import org.immutables.value.Generated;

@Generated(from="RootCredentials", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableRootCredentials
implements RootCredentials {
    private final String clientId;
    private final String clientSecret;
    private transient int hashCode;

    private ImmutableRootCredentials(String clientId, String clientSecret) {
        this.clientId = Objects.requireNonNull(clientId, "clientId");
        this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
    }

    private ImmutableRootCredentials(ImmutableRootCredentials original, String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    @JsonProperty(value="client-id")
    public String clientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="client-secret")
    public String clientSecret() {
        return this.clientSecret;
    }

    public final ImmutableRootCredentials withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return ImmutableRootCredentials.validate(new ImmutableRootCredentials(this, newValue, this.clientSecret));
    }

    public final ImmutableRootCredentials withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return ImmutableRootCredentials.validate(new ImmutableRootCredentials(this, this.clientId, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRootCredentials && this.equalTo(0, (ImmutableRootCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableRootCredentials another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RootCredentials").omitNullValues().add("clientId", (Object)this.clientId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRootCredentials fromJson(Json json) {
        Builder builder = ImmutableRootCredentials.builder();
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.clientSecret != null) {
            builder.clientSecret(json.clientSecret);
        }
        return builder.build();
    }

    public static ImmutableRootCredentials of(String clientId, String clientSecret) {
        return ImmutableRootCredentials.validate(new ImmutableRootCredentials(clientId, clientSecret));
    }

    private static ImmutableRootCredentials validate(ImmutableRootCredentials instance) {
        instance.check();
        return instance;
    }

    public static ImmutableRootCredentials copyOf(RootCredentials instance) {
        if (instance instanceof ImmutableRootCredentials) {
            return (ImmutableRootCredentials)instance;
        }
        return ImmutableRootCredentials.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableRootCredentials.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RootCredentials", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private long initBits = 3L;
        private String clientId;
        private String clientSecret;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RootCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.clientSecret(instance.clientSecret());
            return this;
        }

        @JsonProperty(value="client-id")
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="client-secret")
        @CanIgnoreReturnValue
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.clientId = null;
            this.clientSecret = null;
            return this;
        }

        public ImmutableRootCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRootCredentials.validate(new ImmutableRootCredentials(null, this.clientId, this.clientSecret));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            return "Cannot build RootCredentials, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RootCredentials", generator="Immutables")
    static final class Json
    implements RootCredentials {
        String clientId;
        String clientSecret;

        Json() {
        }

        @JsonProperty(value="client-id")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="client-secret")
        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public String clientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String clientSecret() {
            throw new UnsupportedOperationException();
        }
    }
}

