/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.utils;

import com.google.common.primitives.UnsignedBytes;

public class ByteConvertUtils {
    public static int byteToInt(byte b) {
        return UnsignedBytes.toInt((byte)b);
    }

    public static byte checkCastByte(int i) {
        return UnsignedBytes.checkedCast((long)i);
    }

    public static int lsMsByteToInt(byte lsByte, byte msByte) {
        return (ByteConvertUtils.byteToInt(msByte) << 8) + ByteConvertUtils.byteToInt(lsByte);
    }

    public static byte[] intToLsMsByte(int i) {
        if (i < 0 || i > 65535) {
            throw new IllegalArgumentException("Invalid int value: " + i);
        }
        byte[] bytes = new byte[]{ByteConvertUtils.checkCastByte(i & 0xFF), ByteConvertUtils.checkCastByte(i >> 8 & 0xFF)};
        return bytes;
    }

    public static int getBitsAsSigned(int value, int n) {
        int mask = (1 << n) - 1;
        int lowerBits = value & mask;
        int signBit = 1 << n - 1;
        if ((lowerBits & signBit) != 0) {
            lowerBits |= ~mask;
        }
        return lowerBits;
    }
}

