/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class ReflectiveMethodDefinition
extends MethodDefinition {
    protected Vector<Class<?>> argumentTypes = new Vector(5);
    protected Class<?> type = null;

    public void addArgument(Class<?> argumentType, String argumentName) {
        this.getArgumentNames().addElement(argumentName);
        this.argumentTypes.addElement(argumentType);
    }

    @Override
    protected boolean argumentsEqual(MethodDefinition methodDefinition) {
        Object[] args2;
        Object[] args1 = this.getArgumentTypes().toArray();
        if (args1.length == (args2 = methodDefinition.getArgumentTypes().toArray()).length) {
            for (int i = 0; i < args1.length; ++i) {
                if (args1[i] == args2[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected Vector<String> getArgumentTypeNames() {
        Vector<String> argumentTypeNames = new Vector<String>();
        Iterator<Class<?>> i = this.argumentTypes.iterator();
        while (i.hasNext()) {
            argumentTypeNames.add(i.next().getName());
        }
        return argumentTypeNames;
    }

    @Override
    public Vector<String> getArgumentTypes() {
        return this.getArgumentTypeNames();
    }

    @Override
    protected void writeArguments(CodeGenerator generator) {
        boolean isFirst = true;
        for (int index = 0; index < this.argumentTypes.size(); ++index) {
            Class<?> argument = this.argumentTypes.elementAt(index);
            if (isFirst) {
                isFirst = false;
            } else {
                generator.write(", ");
            }
            if (argument.isArray()) {
                String componentType = argument.getComponentType().getName();
                if (componentType.indexOf(36) != -1) {
                    componentType = componentType.replace('$', '.');
                }
                String componentTypeArrays = componentType + "[]";
                generator.write(componentTypeArrays);
            } else {
                String name = argument.getName();
                if (name.indexOf(36) != -1) {
                    name = name.replace('$', '.');
                }
                generator.write(name);
            }
            generator.write(" ");
            generator.write(this.getArgumentNames().elementAt(index));
        }
    }

    public Class<?> getReturnTypeClass() {
        return this.type;
    }

    public void setReturnTypeClass(Class<?> type) {
        this.type = type;
    }

    @Override
    public String getReturnType() {
        if (this.getReturnTypeClass() != null) {
            if (this.getReturnTypeClass().isArray()) {
                return this.getReturnTypeClass().getComponentType().getName() + "[]";
            }
            return this.getReturnTypeClass().getName();
        }
        return this.returnType;
    }
}

