/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalRadiotapData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapDataAMpduStatus;
import org.pcap4j.packet.RadiotapDataAntenna;
import org.pcap4j.packet.RadiotapDataAntennaNoise;
import org.pcap4j.packet.RadiotapDataAntennaSignal;
import org.pcap4j.packet.RadiotapDataChannel;
import org.pcap4j.packet.RadiotapDataDbAntennaNoise;
import org.pcap4j.packet.RadiotapDataDbAntennaSignal;
import org.pcap4j.packet.RadiotapDataDbTxAttenuation;
import org.pcap4j.packet.RadiotapDataDbmTxPower;
import org.pcap4j.packet.RadiotapDataFhss;
import org.pcap4j.packet.RadiotapDataFlags;
import org.pcap4j.packet.RadiotapDataLockQuality;
import org.pcap4j.packet.RadiotapDataMcs;
import org.pcap4j.packet.RadiotapDataRate;
import org.pcap4j.packet.RadiotapDataRxFlags;
import org.pcap4j.packet.RadiotapDataTsft;
import org.pcap4j.packet.RadiotapDataTxAttenuation;
import org.pcap4j.packet.RadiotapDataVht;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.UnknownRadiotapData;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.RadiotapPresentBitNumber;

public final class StaticRadiotapDataFieldFactory
implements PacketFactory<RadiotapPacket.RadiotapData, RadiotapPresentBitNumber> {
    private static final StaticRadiotapDataFieldFactory INSTANCE = new StaticRadiotapDataFieldFactory();
    private final Map<RadiotapPresentBitNumber, Instantiater> instantiaters = new HashMap<RadiotapPresentBitNumber, Instantiater>();

    private StaticRadiotapDataFieldFactory() {
        this.instantiaters.put(RadiotapPresentBitNumber.TSFT, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataTsft.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataTsft> getTargetClass() {
                return RadiotapDataTsft.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.FLAGS, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataFlags.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataFlags> getTargetClass() {
                return RadiotapDataFlags.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.RATE, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataRate.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataRate> getTargetClass() {
                return RadiotapDataRate.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.CHANNEL, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataChannel.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataChannel> getTargetClass() {
                return RadiotapDataChannel.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.FHSS, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataFhss.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataFhss> getTargetClass() {
                return RadiotapDataFhss.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.ANTENNA_SIGNAL, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataAntennaSignal.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataAntennaSignal> getTargetClass() {
                return RadiotapDataAntennaSignal.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.ANTENNA_NOISE, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataAntennaNoise.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataAntennaNoise> getTargetClass() {
                return RadiotapDataAntennaNoise.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.LOCK_QUALITY, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataLockQuality.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataLockQuality> getTargetClass() {
                return RadiotapDataLockQuality.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.TX_ATTENUATION, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataTxAttenuation.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataTxAttenuation> getTargetClass() {
                return RadiotapDataTxAttenuation.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.DB_TX_ATTENUATION, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataDbTxAttenuation.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataDbTxAttenuation> getTargetClass() {
                return RadiotapDataDbTxAttenuation.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.DBM_TX_POWER, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataDbmTxPower.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataDbmTxPower> getTargetClass() {
                return RadiotapDataDbmTxPower.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.ANTENNA, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataAntenna.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataAntenna> getTargetClass() {
                return RadiotapDataAntenna.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.DB_ANTENNA_SIGNAL, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataDbAntennaSignal.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataDbAntennaSignal> getTargetClass() {
                return RadiotapDataDbAntennaSignal.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.DB_ANTENNA_NOISE, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataDbAntennaNoise.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataDbAntennaNoise> getTargetClass() {
                return RadiotapDataDbAntennaNoise.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.RX_FLAGS, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataRxFlags.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataRxFlags> getTargetClass() {
                return RadiotapDataRxFlags.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.MCS, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataMcs.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataMcs> getTargetClass() {
                return RadiotapDataMcs.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.A_MPDU_STATUS, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataAMpduStatus.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataAMpduStatus> getTargetClass() {
                return RadiotapDataAMpduStatus.class;
            }
        });
        this.instantiaters.put(RadiotapPresentBitNumber.VHT, new Instantiater(){

            @Override
            public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapDataVht.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapDataVht> getTargetClass() {
                return RadiotapDataVht.class;
            }
        });
    }

    public static StaticRadiotapDataFieldFactory getInstance() {
        return INSTANCE;
    }

    public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length, RadiotapPresentBitNumber number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalRadiotapData.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        return this.newInstance(rawData, offset, length);
    }

    public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) {
        return UnknownRadiotapData.newInstance((byte[])rawData, (int)offset, (int)length);
    }

    public Class<? extends RadiotapPacket.RadiotapData> getTargetClass(RadiotapPresentBitNumber number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends RadiotapPacket.RadiotapData> getTargetClass() {
        return UnknownRadiotapData.class;
    }

    private static interface Instantiater {
        public RadiotapPacket.RadiotapData newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends RadiotapPacket.RadiotapData> getTargetClass();
    }
}

