/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.functional.ConsumerRaisingIOE;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class RemoteIterators {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteIterators.class);

    private RemoteIterators() {
    }

    public static <T> RemoteIterator<T> remoteIteratorFromSingleton(@Nullable T singleton) {
        return new SingletonIterator(singleton);
    }

    public static <T> RemoteIterator<T> remoteIteratorFromIterator(Iterator<T> iterator2) {
        return new WrappedJavaIterator(iterator2);
    }

    public static <T> RemoteIterator<T> remoteIteratorFromIterable(Iterable<T> iterable) {
        return new WrappedJavaIterator(iterable.iterator());
    }

    public static <T> RemoteIterator<T> remoteIteratorFromArray(T[] array) {
        return new WrappedJavaIterator(Arrays.stream(array).iterator());
    }

    public static <S, T> RemoteIterator<T> mappingRemoteIterator(RemoteIterator<S> iterator2, FunctionRaisingIOE<? super S, T> mapper) {
        return new MappingRemoteIterator(iterator2, mapper);
    }

    public static <S, T> RemoteIterator<T> typeCastingRemoteIterator(RemoteIterator<S> iterator2) {
        return new TypeCastingRemoteIterator(iterator2);
    }

    public static <S> RemoteIterator<S> filteringRemoteIterator(RemoteIterator<S> iterator2, FunctionRaisingIOE<? super S, Boolean> filter) {
        return new FilteringRemoteIterator(iterator2, filter);
    }

    public static <S> RemoteIterator<S> closingRemoteIterator(RemoteIterator<S> iterator2, Closeable toClose) {
        return new CloseRemoteIterator(iterator2, toClose);
    }

    public static <T> List<T> toList(RemoteIterator<T> source2) throws IOException {
        ArrayList l = new ArrayList();
        RemoteIterators.foreach(source2, l::add);
        return l;
    }

    public static <T> T[] toArray(RemoteIterator<T> source2, T[] a) throws IOException {
        List<T> list = RemoteIterators.toList(source2);
        return list.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long foreach(RemoteIterator<T> source2, ConsumerRaisingIOE<? super T> consumer) throws IOException {
        long count = 0L;
        try {
            while (source2.hasNext()) {
                ++count;
                consumer.accept(source2.next());
            }
        }
        finally {
            RemoteIterators.cleanupRemoteIterator(source2);
        }
        return count;
    }

    public static <T> void cleanupRemoteIterator(RemoteIterator<T> source2) {
        IOStatisticsLogging.logIOStatisticsAtDebug(LOG, "RemoteIterator Statistics: {}", source2);
        if (source2 instanceof Closeable) {
            IOUtils.cleanupWithLogger(LOG, (Closeable)((Object)source2));
        }
    }

    private static final class MaybeClose
    implements Closeable {
        private Closeable toClose;

        private MaybeClose(Object o) {
            this(o, true);
        }

        private MaybeClose(Object o, boolean close) {
            this.toClose = close && o instanceof Closeable ? (Closeable)o : null;
        }

        @Override
        public void close() throws IOException {
            if (this.toClose != null) {
                try {
                    this.toClose.close();
                }
                finally {
                    this.toClose = null;
                }
            }
        }
    }

    private static final class CloseRemoteIterator<S>
    extends WrappingRemoteIterator<S, S> {
        private final MaybeClose toClose;
        private boolean closed;

        private CloseRemoteIterator(RemoteIterator<S> source2, Closeable toClose) {
            super(source2);
            this.toClose = new MaybeClose((Object)Objects.requireNonNull(toClose));
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.sourceHasNext();
        }

        @Override
        public S next() throws IOException {
            return this.sourceNext();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            LOG.debug("Closing {}", (Object)this);
            try {
                super.close();
            }
            finally {
                this.toClose.close();
            }
        }
    }

    private static final class FilteringRemoteIterator<S>
    extends WrappingRemoteIterator<S, S> {
        private final FunctionRaisingIOE<? super S, Boolean> filter;
        private S next;

        private FilteringRemoteIterator(RemoteIterator<S> source2, FunctionRaisingIOE<? super S, Boolean> filter) {
            super(source2);
            this.filter = Objects.requireNonNull(filter);
        }

        private boolean fetch() throws IOException {
            while (this.next == null && this.sourceHasNext()) {
                Object candidate = this.getSource().next();
                if (!this.filter.apply(candidate).booleanValue()) continue;
                this.next = candidate;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            return this.fetch();
        }

        @Override
        public S next() throws IOException {
            if (this.hasNext()) {
                S result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "FilteringRemoteIterator{" + this.getSource() + '}';
        }
    }

    private static final class TypeCastingRemoteIterator<S, T>
    extends WrappingRemoteIterator<S, T> {
        private TypeCastingRemoteIterator(RemoteIterator<S> source2) {
            super(source2);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.sourceHasNext();
        }

        @Override
        public T next() throws IOException {
            return (T)this.sourceNext();
        }

        @Override
        public String toString() {
            return this.getSource().toString();
        }
    }

    private static final class MappingRemoteIterator<S, T>
    extends WrappingRemoteIterator<S, T> {
        private final FunctionRaisingIOE<? super S, T> mapper;

        private MappingRemoteIterator(RemoteIterator<S> source2, FunctionRaisingIOE<? super S, T> mapper) {
            super(source2);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.sourceHasNext();
        }

        @Override
        public T next() throws IOException {
            return this.mapper.apply(this.sourceNext());
        }

        @Override
        public String toString() {
            return "FunctionRemoteIterator{" + this.getSource() + '}';
        }
    }

    private static abstract class WrappingRemoteIterator<S, T>
    implements RemoteIterator<T>,
    IOStatisticsSource,
    Closeable {
        private final RemoteIterator<S> source;
        private final Closeable sourceToClose;

        protected WrappingRemoteIterator(RemoteIterator<S> source2) {
            this.source = Objects.requireNonNull(source2);
            this.sourceToClose = new MaybeClose(source2);
        }

        protected RemoteIterator<S> getSource() {
            return this.source;
        }

        @Override
        public IOStatistics getIOStatistics() {
            return IOStatisticsSupport.retrieveIOStatistics(this.source);
        }

        @Override
        public void close() throws IOException {
            this.sourceToClose.close();
        }

        protected boolean sourceHasNext() throws IOException {
            boolean hasNext;
            try {
                hasNext = this.getSource().hasNext();
            }
            catch (IOException e) {
                IOUtils.cleanupWithLogger(LOG, this);
                throw e;
            }
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        protected S sourceNext() throws IOException {
            try {
                if (!this.sourceHasNext()) {
                    throw new NoSuchElementException();
                }
                return this.getSource().next();
            }
            catch (IOException | NoSuchElementException e) {
                IOUtils.cleanupWithLogger(LOG, this);
                throw e;
            }
        }

        public String toString() {
            return this.source.toString();
        }
    }

    private static final class WrappedJavaIterator<T>
    implements RemoteIterator<T>,
    IOStatisticsSource,
    Closeable {
        private final Iterator<? extends T> source;
        private final Closeable sourceToClose;

        private WrappedJavaIterator(Iterator<? extends T> source2) {
            this.source = Objects.requireNonNull(source2);
            this.sourceToClose = new MaybeClose(source2);
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public T next() {
            return this.source.next();
        }

        @Override
        public IOStatistics getIOStatistics() {
            return IOStatisticsSupport.retrieveIOStatistics(this.source);
        }

        public String toString() {
            return "FromIterator{" + this.source + '}';
        }

        @Override
        public void close() throws IOException {
            this.sourceToClose.close();
        }
    }

    private static final class SingletonIterator<T>
    implements RemoteIterator<T>,
    IOStatisticsSource {
        private final T singleton;
        private boolean processed;

        private SingletonIterator(@Nullable T singleton) {
            this.singleton = singleton;
            this.processed = singleton == null;
        }

        @Override
        public boolean hasNext() throws IOException {
            return !this.processed;
        }

        @Override
        public T next() throws IOException {
            if (this.hasNext()) {
                this.processed = true;
                return this.singleton;
            }
            throw new NoSuchElementException();
        }

        @Override
        public IOStatistics getIOStatistics() {
            return IOStatisticsSupport.retrieveIOStatistics(this.singleton);
        }

        public String toString() {
            return "SingletonIterator{" + (this.singleton != null ? this.singleton : "") + '}';
        }
    }
}

