/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class SetReplication
extends FsCommand {
    public static final String NAME = "setrep";
    public static final String USAGE = "[-R] [-w] <rep> <path> ...";
    public static final String DESCRIPTION = "Set the replication level of a file. If <path> is a directory then the command recursively changes the replication factor of all files under the directory tree rooted at <path>. The EC files will be ignored here.\n-w: It requests that the command waits for the replication to complete. This can potentially take a very long time.\n-R: It is accepted for backwards compatibility. It has no effect.";
    protected short newRep = 0;
    protected List<PathData> waitList = new LinkedList<PathData>();
    protected boolean waitOpt = false;

    SetReplication() {
    }

    public static void registerCommands(CommandFactory factory2) {
        factory2.addClass(SetReplication.class, "-setrep");
    }

    @Override
    protected void processOptions(LinkedList<String> args2) throws IOException {
        CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, "R", "w");
        cf.parse(args2);
        this.waitOpt = cf.getOpt("w");
        this.setRecursive(true);
        try {
            this.newRep = Short.parseShort(args2.removeFirst());
        }
        catch (NumberFormatException nfe) {
            this.displayWarning("Illegal replication, a positive integer expected");
            throw nfe;
        }
        if (this.newRep < 1) {
            throw new IllegalArgumentException("replication must be >= 1");
        }
    }

    @Override
    protected void processArguments(LinkedList<PathData> args2) throws IOException {
        super.processArguments(args2);
        if (this.waitOpt) {
            this.waitForReplication();
        }
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isSymlink()) {
            throw new PathIOException(item.toString(), "Symlinks unsupported");
        }
        if (item.stat.isFile()) {
            if (!item.stat.isErasureCoded()) {
                if (!item.fs.setReplication(item.path, this.newRep)) {
                    throw new IOException("Could not set replication for: " + item);
                }
                this.out.println("Replication " + this.newRep + " set: " + item);
                if (this.waitOpt) {
                    this.waitList.add(item);
                }
            } else {
                this.out.println("Did not set replication for: " + item + ", because it's an erasure coded file.");
            }
        }
    }

    private void waitForReplication() throws IOException {
        for (PathData item : this.waitList) {
            this.out.print("Waiting for " + item + " ...");
            this.out.flush();
            boolean printedWarning = false;
            boolean done = false;
            while (!done) {
                int i;
                item.refreshStatus();
                BlockLocation[] locations = item.fs.getFileBlockLocations(item.stat, 0L, item.stat.getLen());
                for (i = 0; i < locations.length; ++i) {
                    int currentRep = locations[i].getHosts().length;
                    if (currentRep == this.newRep) continue;
                    if (printedWarning || currentRep <= this.newRep) break;
                    this.out.println("\nWARNING: the waiting time may be long for DECREASING the number of replications.");
                    printedWarning = true;
                    break;
                }
                boolean bl = done = i == locations.length;
                if (done) break;
                this.out.print(".");
                this.out.flush();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.out.println(" done");
        }
    }
}

