/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.RandomAccessFile;
import java.util.Objects;

public interface CacheKey {
    public static CacheKey forPosition(RandomAccessFile file, long position, int length, boolean isIndex) {
        return new PositionCacheKey(file, position, length, isIndex);
    }

    public static CacheKey forPageIndex(RandomAccessFile file, int pageSize, int pageIndex) {
        return new PageIndexCacheKey(file, pageSize, pageIndex, false);
    }

    public boolean isIndex();

    public static class PageIndexCacheKey
    implements CacheKey {
        private final RandomAccessFile file;
        private final int pageSize;
        private final int pageIndex;
        private final boolean isIndex;

        private PageIndexCacheKey(RandomAccessFile file, int pageSize, int pageIndex, boolean isIndex) {
            this.file = file;
            this.pageSize = pageSize;
            this.pageIndex = pageIndex;
            this.isIndex = isIndex;
        }

        public int pageIndex() {
            return this.pageIndex;
        }

        @Override
        public boolean isIndex() {
            return this.isIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageIndexCacheKey that = (PageIndexCacheKey)o;
            return this.pageSize == that.pageSize && this.pageIndex == that.pageIndex && this.isIndex == that.isIndex && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.pageSize, this.pageIndex, this.isIndex);
        }
    }

    public static class PositionCacheKey
    implements CacheKey {
        private final RandomAccessFile file;
        private final long position;
        private final int length;
        private final boolean isIndex;

        private PositionCacheKey(RandomAccessFile file, long position, int length, boolean isIndex) {
            this.file = file;
            this.position = position;
            this.length = length;
            this.isIndex = isIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionCacheKey that = (PositionCacheKey)o;
            return this.position == that.position && this.length == that.length && this.isIndex == that.isIndex && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.position, this.length, this.isIndex);
        }

        @Override
        public boolean isIndex() {
            return this.isIndex;
        }
    }
}

