/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;

public class FormatFactoryUtil {
    private static final Cache<ClassLoader, List<FileFormatFactory>> FACTORIES = Caffeine.newBuilder().softValues().maximumSize(100L).executor(Runnable::run).build();

    public static <T extends FileFormatFactory> T discoverFactory(ClassLoader classLoader, String identifier) {
        List<FileFormatFactory> foundFactories = FormatFactoryUtil.getFactories(classLoader);
        List matchingFactories = foundFactories.stream().filter(f -> f.identifier().equals(identifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factory for identifier '%s' that implements FileFormatFactory in the classpath.\n\nAvailable factory identifiers are:\n\n%s", identifier, foundFactories.stream().map(FileFormatFactory::identifier).collect(Collectors.joining("\n"))));
        }
        return (T)((FileFormatFactory)matchingFactories.get(0));
    }

    private static List<FileFormatFactory> getFactories(ClassLoader classLoader) {
        return FACTORIES.get(classLoader, s -> FactoryUtil.discoverFactories(classLoader, FileFormatFactory.class));
    }
}

