/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils.gatekeeper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;

public class GatekeeperMessage {
    private static final Log log = LogFactory.getLog(GatekeeperMessage.class);
    public static final String DELIM = "|";
    public static final String PROPERTY_TRANSACTION_ID = "transactionId";
    public static final String PROPERTY_PRIOR_FAILURE_MESSAGE = "priorFailureMessage";
    public static final String PROPERTY_CLIENT_VERSION_ID = "clientVersionId";
    public static final String APP_PROPERTY_GATEKEEPER_ERROR_CODE = "gatekeeperErrorCode";
    public static final String SUMMARY_DOCUMENT_METADATA_FLAG = "jets3t-uploader-summary-doc";
    public static final String LIST_OBJECTS_IN_BUCKET_FLAG = "list-objects-in-bucket";
    private Properties applicationProperties = new Properties();
    private Properties messageProperties = new Properties();
    private List signatureRequestList = new ArrayList();

    public void addSignatureRequest(SignatureRequest signatureRequest) {
        this.signatureRequestList.add(signatureRequest);
    }

    public void addSignatureRequests(SignatureRequest[] signatureRequests) {
        for (int i = 0; i < signatureRequests.length; ++i) {
            this.addSignatureRequest(signatureRequests[i]);
        }
    }

    public SignatureRequest[] getSignatureRequests() {
        return this.signatureRequestList.toArray(new SignatureRequest[this.signatureRequestList.size()]);
    }

    public void addApplicationProperty(String propertyName, String propertyValue) {
        this.applicationProperties.put(propertyName, propertyValue);
    }

    public void addApplicationProperties(Map propertiesMap) {
        this.applicationProperties.putAll((Map<?, ?>)propertiesMap);
    }

    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void addMessageProperty(String propertyName, String propertyValue) {
        this.messageProperties.put(propertyName, propertyValue);
    }

    public void addMessageProperties(Map propertiesMap) {
        this.messageProperties.putAll((Map<?, ?>)propertiesMap);
    }

    public Properties getMessageProperties() {
        return this.messageProperties;
    }

    private void encodeProperty(Properties properties, String propertyName, Object value) {
        if (value != null) {
            if (value instanceof Date) {
                properties.put(propertyName, ServiceUtils.formatIso8601Date((Date)value));
            } else {
                properties.put(propertyName, value.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("Encoded property: " + propertyName + "=" + properties.getProperty(propertyName));
            }
        }
    }

    public Properties encodeToProperties() {
        String value;
        String key;
        if (log.isDebugEnabled()) {
            log.debug("Encoding GatekeeperMessage to properties");
        }
        Properties encodedProperties = new Properties();
        Iterator<Map.Entry<Object, Object>> iter = null;
        String prefix = "application";
        for (Map.Entry<Object, Object> entry : this.applicationProperties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            this.encodeProperty(encodedProperties, prefix + DELIM + key, value);
        }
        prefix = "message";
        for (Map.Entry<Object, Object> entry : this.messageProperties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            this.encodeProperty(encodedProperties, prefix + DELIM + key, value);
        }
        prefix = "request";
        SignatureRequest[] requests = this.getSignatureRequests();
        for (int i = 0; i < requests.length; ++i) {
            SignatureRequest request = requests[i];
            String propertyPrefix = prefix + DELIM + i + DELIM;
            this.encodeProperty(encodedProperties, propertyPrefix + "signatureType", request.getSignatureType());
            this.encodeProperty(encodedProperties, propertyPrefix + "objectKey", request.getObjectKey());
            this.encodeProperty(encodedProperties, propertyPrefix + "bucketName", request.getBucketName());
            this.encodeProperty(encodedProperties, propertyPrefix + "signedUrl", request.getSignedUrl());
            this.encodeProperty(encodedProperties, propertyPrefix + "declineReason", request.getDeclineReason());
            propertyPrefix = propertyPrefix + "metadata|";
            Map metadata = request.getObjectMetadata();
            for (Map.Entry<Object, Object> entry : metadata.entrySet()) {
                String metadataName = (String)entry.getKey();
                Object metadataValue = entry.getValue();
                this.encodeProperty(encodedProperties, propertyPrefix + metadataName, metadataValue);
            }
        }
        return encodedProperties;
    }

    public static GatekeeperMessage decodeFromProperties(Map postProperties) {
        if (log.isDebugEnabled()) {
            log.debug("Decoding GatekeeperMessage from properties");
        }
        GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
        HashMap<Integer, SignatureRequest> signatureRequestMap = new HashMap<Integer, SignatureRequest>();
        for (Map.Entry entry : postProperties.entrySet()) {
            String propertyName;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String propertyValue = null;
            propertyValue = value instanceof String[] ? ((String[])value)[0] : (String)value;
            if (key.startsWith("application")) {
                propertyName = key.substring(key.lastIndexOf(DELIM) + 1);
                gatekeeperMessage.addApplicationProperty(propertyName, propertyValue);
                continue;
            }
            if (key.startsWith("message")) {
                propertyName = key.substring(key.lastIndexOf(DELIM) + 1);
                gatekeeperMessage.addMessageProperty(propertyName, propertyValue);
                continue;
            }
            if (key.startsWith("request")) {
                StringTokenizer st = new StringTokenizer(key, DELIM);
                st.nextToken();
                String objectIndexStr = st.nextToken();
                boolean isMetadata = false;
                String propertyName2 = st.nextToken();
                if (st.hasMoreTokens()) {
                    isMetadata = true;
                    propertyName2 = st.nextToken();
                }
                Integer objectIndex = Integer.valueOf(objectIndexStr);
                SignatureRequest request = null;
                if (signatureRequestMap.containsKey(objectIndex)) {
                    request = (SignatureRequest)signatureRequestMap.get(objectIndex);
                } else {
                    request = new SignatureRequest();
                    signatureRequestMap.put(objectIndex, request);
                }
                if (isMetadata) {
                    request.addObjectMetadata(propertyName2, propertyValue);
                    continue;
                }
                if ("signatureType".equals(propertyName2)) {
                    request.setSignatureType(propertyValue);
                    continue;
                }
                if ("objectKey".equals(propertyName2)) {
                    request.setObjectKey(propertyValue);
                    continue;
                }
                if ("bucketName".equals(propertyName2)) {
                    request.setBucketName(propertyValue);
                    continue;
                }
                if ("signedUrl".equals(propertyName2)) {
                    request.signRequest(propertyValue);
                    continue;
                }
                if ("declineReason".equals(propertyName2)) {
                    request.declineRequest(propertyValue);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Ignoring unrecognised SignatureRequest property: " + propertyName2);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn("Ignoring unrecognised property name: " + key);
        }
        for (int i = 0; i < signatureRequestMap.size(); ++i) {
            Integer objectIndex = new Integer(i);
            SignatureRequest request = (SignatureRequest)signatureRequestMap.get(objectIndex);
            gatekeeperMessage.addSignatureRequest(request);
        }
        return gatekeeperMessage;
    }
}

