/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FractionalGridCoordinates
implements Serializable {
    private static final long serialVersionUID = 5652265407347129550L;
    final double[] coordinates;

    public FractionalGridCoordinates(int dimension) {
        this.coordinates = new double[dimension];
    }

    public FractionalGridCoordinates(FractionalGridCoordinates other) {
        this.coordinates = (double[])other.coordinates.clone();
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public long[] getCoordinateValues() {
        long[] indices = new long[this.coordinates.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.getCoordinateValue(i);
        }
        return indices;
    }

    public long getCoordinateValue(int dimension) {
        double value = this.coordinates[dimension];
        if (value >= -9.223372036854778E18 && value <= 9.223372036854778E18) {
            return Math.round(value);
        }
        throw new ArithmeticException(Resources.format((short)65, "long", value));
    }

    public double getCoordinateFractional(int dimension) {
        return this.coordinates[dimension];
    }

    public void setCoordinateValue(int dimension, long value) {
        this.coordinates[dimension] = value;
        if (this.coordinates[dimension] != (double)value) {
            throw new ArithmeticException(Resources.format((short)65, "double", value));
        }
    }

    public GridExtent toExtent(GridExtent bounds, long ... size) {
        return this.toExtent(bounds, size, false);
    }

    final GridExtent toExtent(GridExtent bounds, long[] size, boolean nullIfOutside) {
        int bd;
        int dimension = this.coordinates.length;
        if (bounds != null && (bd = bounds.getDimension()) != dimension) {
            throw new MismatchedDimensionException(Errors.format((short)81, (Object)"bounds", (Object)dimension, (Object)bd));
        }
        long[] extent = GridExtent.allocate(dimension);
        for (int i = 0; i < dimension; ++i) {
            long lower;
            long upper;
            double value = this.coordinates[i];
            if (!(value >= -9.223372036854776E18) || !(value <= 9.223372036854776E18)) {
                throw new ArithmeticException(Resources.format((short)65, "long", value));
            }
            long margin = 0L;
            if (i < size.length && (margin = size[i]) < 0L) {
                throw new IllegalArgumentException(Errors.format((short)92, (Object)Strings.toIndexed((String)"size", (int)i), (Object)margin));
            }
            long nearest = Math.round(value);
            if (margin == 1L) {
                lower = upper = nearest;
            } else {
                lower = (long)Math.floor(value);
                upper = (long)Math.ceil(value);
                if (margin != 0L) {
                    assert ((margin -= upper - lower + 1L) >= 0L) : margin;
                    if ((margin & 1L) != 0L) {
                        if (nearest >= upper) {
                            upper = Math.incrementExact(upper);
                        } else {
                            lower = Math.decrementExact(lower);
                        }
                    }
                    lower = Math.subtractExact(lower, margin >>= 1);
                    upper = Math.addExact(upper, margin);
                    margin = 2L;
                }
            }
            if (bounds != null) {
                long t;
                long validMin = bounds.getLow(i);
                long validMax = bounds.getHigh(i);
                if (nearest > validMax || nearest < validMin) {
                    if (nullIfOutside) {
                        return null;
                    }
                    StringBuilder b = new StringBuilder();
                    this.writeCoordinates(b);
                    throw new PointOutsideCoverageException(Resources.format((short)21, bounds.getAxisIdentification(i, i), validMin, validMax, b.toString()));
                }
                if (upper > validMax) {
                    if (margin != 0L) {
                        t = lower - Math.subtractExact(upper, validMax);
                        lower = t >= validMin && t <= lower ? t : validMin;
                    }
                    upper = validMax;
                }
                if (lower < validMin) {
                    if (margin != 0L) {
                        t = upper + Math.subtractExact(validMin, lower);
                        upper = t <= validMax && t >= upper ? t : validMax;
                    }
                    lower = validMin;
                }
            }
            extent[i] = lower;
            extent[i + dimension] = upper;
        }
        return new GridExtent(bounds, extent);
    }

    public DirectPosition toPosition(MathTransform gridToCRS) throws TransformException {
        return gridToCRS.transform((DirectPosition)new Position(this), null);
    }

    final String pointOutsideCoverage(GridExtent bounds) {
        if (bounds == null) {
            return null;
        }
        int axis = 0;
        long validMin = 0L;
        long validMax = 0L;
        double distance = 0.0;
        int i = bounds.getDimension();
        while (--i >= 0) {
            long low = bounds.getLow(i);
            long high = bounds.getHigh(i);
            double c = this.coordinates[i];
            double d = (double)low - c;
            if (!(d > distance) && !((d = c - (double)high) > distance)) continue;
            axis = i;
            validMin = low;
            validMax = high;
            distance = d;
        }
        StringBuilder b = new StringBuilder();
        this.writeCoordinates(b);
        return Resources.format((short)21, bounds.getAxisIdentification(axis, axis), validMin, validMax, b.toString());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("GridCoordinates[");
        this.writeCoordinates(buffer);
        return buffer.append(']').toString();
    }

    private void writeCoordinates(StringBuilder buffer) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (i != 0) {
                buffer.append(' ');
            }
            StringBuilders.trimFractionalPart((StringBuilder)buffer.append(this.coordinates[i]));
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) ^ 0xE5277CCE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Arrays.equals(((FractionalGridCoordinates)object).coordinates, this.coordinates);
        }
        return false;
    }

    static final class Position
    extends FractionalGridCoordinates
    implements DirectPosition {
        private static final long serialVersionUID = -7804151694395153401L;

        Position(int dimension) {
            super(dimension);
        }

        Position(FractionalGridCoordinates other) {
            super(other);
        }

        public DirectPosition getDirectPosition() {
            return this;
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return null;
        }

        public double[] getCoordinate() {
            return (double[])this.coordinates.clone();
        }

        public double getOrdinate(int dimension) {
            return this.coordinates[dimension];
        }

        public void setOrdinate(int dimension, double value) {
            this.coordinates[dimension] = value;
        }

        @Override
        public DirectPosition toPosition(MathTransform gridToCRS) throws TransformException {
            return gridToCRS.transform((DirectPosition)this, null);
        }
    }
}

