/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class FloorNode
extends MathOperation {
    public FloorNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int floorInt(int a) {
        return a;
    }

    @Specialization
    protected static SafeInteger floorSafeInt(SafeInteger a) {
        return a;
    }

    @Specialization
    protected final Object floorDouble(double d, @Cached @Cached.Shared(value="isZero") InlinedConditionProfile isZero, @Cached @Cached.Shared(value="fitsInt") InlinedConditionProfile fitsInt, @Cached @Cached.Shared(value="fitsSafeLong") InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared(value="smaller") InlinedConditionProfile smaller) {
        if (isZero.profile((Node)this, d == 0.0)) {
            return d;
        }
        if (fitsInt.profile((Node)this, d >= -2.147483648E9 && d <= 2.147483647E9)) {
            int i = (int)d;
            return smaller.profile((Node)this, d < (double)i) ? i - 1 : i;
        }
        if (fitsSafeLong.profile((Node)this, JSRuntime.isSafeInteger(d))) {
            long i = (long)d;
            long result = smaller.profile((Node)this, d < (double)i) ? i - 1L : i;
            return SafeInteger.valueOf(result);
        }
        return Math.floor(d);
    }

    @Specialization(replaces={"floorDouble"})
    protected final Object floorToDouble(Object a, @Cached @Cached.Shared(value="isZero") InlinedConditionProfile isZero, @Cached @Cached.Shared(value="fitsInt") InlinedConditionProfile fitsInt, @Cached @Cached.Shared(value="fitsSafeLong") InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared(value="smaller") InlinedConditionProfile smaller) {
        double d = this.toDouble(a);
        return this.floorDouble(d, isZero, fitsInt, fitsSafeLong, smaller);
    }
}

