/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface DataCollection<E>
extends Iterable<E> {
    public long size();

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public Iterator<E> iterator();

    @Override
    default public Spliterator<E> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    default public boolean addAll(Iterable<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    default public boolean contains(Object o) {
        for (E e : this) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(Iterable<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public void clear();
}

