/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.FeatureAnalyzer;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.util.internal.Strings;

final class TableAnalyzer
extends FeatureAnalyzer {
    private final TableReference dependencyOf;
    private final String tableEsc;
    private final String schemaEsc;

    TableAnalyzer(Analyzer analyzer, TableReference id, TableReference dependencyOf) throws SQLException {
        super(analyzer, id);
        this.dependencyOf = dependencyOf;
        this.tableEsc = this.escape(id.table);
        this.schemaEsc = this.escape(id.schema);
        try (ResultSet reflect = analyzer.metadata.getPrimaryKeys(id.catalog, id.schema, id.table);){
            while (reflect.next()) {
                this.primaryKey.add(analyzer.getUniqueString(reflect, "COLUMN_NAME"));
            }
        }
    }

    private String escape(String pattern) {
        return SQLUtilities.escape((String)pattern, (String)this.analyzer.escape);
    }

    @Override
    final Relation[] getForeignerKeys(Relation.Direction direction) throws SQLException, DataStoreException {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        boolean isImport = direction == Relation.Direction.IMPORT;
        try (ResultSet reflect = isImport ? this.analyzer.metadata.getImportedKeys(this.id.catalog, this.id.schema, this.id.table) : this.analyzer.metadata.getExportedKeys(this.id.catalog, this.id.schema, this.id.table);){
            if (reflect.next()) {
                do {
                    Relation relation;
                    if ((relation = new Relation(this.analyzer, direction, reflect)).equals(this.dependencyOf)) {
                        if (!isImport) continue;
                        SchemaModifier customizer = this.analyzer.customizer;
                        boolean bl = relation.excluded = customizer == null || !customizer.isCyclicAssociationAllowed(this.id);
                    }
                    if (isImport) {
                        this.addForeignerKeys(relation);
                    } else if (relation.excluded) continue;
                    relations.add(relation);
                } while (!reflect.isClosed());
            }
        }
        int size = relations.size();
        return size != 0 ? relations.toArray(new Relation[size]) : Relation.EMPTY;
    }

    @Override
    final Column[] createAttributes() throws Exception {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        String quote = this.analyzer.metadata.getIdentifierQuoteString();
        try (ResultSet reflect = this.analyzer.metadata.getColumns(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
            while (reflect.next()) {
                Column column = new Column(this.analyzer, reflect, quote);
                if (columns.put(column.name, column) == null) continue;
                throw this.duplicatedColumn(column);
            }
        }
        InfoStatements spatialInformation = this.analyzer.spatialInformation;
        if (spatialInformation != null) {
            spatialInformation.completeIntrospection(this.id, columns);
        }
        ArrayList<Column> attributes = new ArrayList<Column>();
        for (Column column : columns.values()) {
            if (!this.createAttribute(column)) continue;
            attributes.add(column);
        }
        return (Column[])attributes.toArray(Column[]::new);
    }

    @Override
    public String getRemarks() throws SQLException {
        if (this.id instanceof Relation) {
            try (ResultSet reflect = this.analyzer.metadata.getTables(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
                while (reflect.next()) {
                    String remarks = Strings.trimOrNull((String)this.analyzer.getUniqueString(reflect, "REMARKS"));
                    if (remarks == null) continue;
                    String string = remarks;
                    return string;
                }
            }
        }
        return super.getRemarks();
    }
}

