/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.QueryAnalyzer;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.storage.sql.feature.TableAnalyzer;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

final class Analyzer {
    final Database<?> database;
    final InfoStatements spatialInformation;
    final DatabaseMetaData metadata;
    final NameFactory nameFactory;
    private final Map<String, String> strings;
    final String escape;
    private final Map<GenericName, Table> tables;
    private final Set<ResourceInternationalString> warnings;
    private transient String catalog;
    private transient String schema;
    private transient NameSpace namespace;
    final SchemaModifier customizer;

    Analyzer(Database<?> database, Connection connection, DatabaseMetaData metadata, SchemaModifier customizer) throws SQLException {
        this.database = database;
        this.tables = new HashMap<GenericName, Table>();
        this.strings = new HashMap<String, String>();
        this.warnings = new LinkedHashSet<ResourceInternationalString>();
        this.customizer = customizer;
        this.metadata = metadata;
        this.escape = metadata.getSearchStringEscape();
        this.nameFactory = DefaultNameFactory.provider();
        this.spatialInformation = database.isSpatial() ? database.createInfoStatements(connection) : null;
    }

    final String getUniqueString(ResultSet reflect, String column) throws SQLException {
        String p;
        String value = reflect.getString(column);
        if (value != null && (p = this.strings.putIfAbsent(value, value)) != null) {
            value = p;
        }
        return value;
    }

    final NameSpace namespace(String catalog, String schema) {
        if (!Objects.equals(this.schema, schema) || !Objects.equals(this.catalog, catalog)) {
            if (schema != null) {
                Object name = catalog == null ? this.nameFactory.createLocalName(null, (CharSequence)schema) : this.nameFactory.createGenericName(null, new CharSequence[]{catalog, schema});
                this.namespace = this.nameFactory.createNameSpace((GenericName)name, Map.of("separator", "."));
            } else {
                this.namespace = null;
            }
            this.catalog = catalog;
            this.schema = schema;
        }
        return this.namespace;
    }

    public final Table table(TableReference id, GenericName name, TableReference dependencyOf) throws Exception {
        Table table = this.tables.get(name);
        if (table == null && !this.tables.containsKey(name)) {
            this.tables.put(name, null);
            table = new Table(this.database, new TableAnalyzer(this, id, dependencyOf), null);
            if (this.tables.put(name, table) != null) {
                throw new InternalDataStoreException(this.internalError());
            }
        }
        return table;
    }

    public final Table query(GenericName name, String query) throws Exception {
        Table table = new Table(this.database, new QueryAnalyzer(this, name, query, null), query);
        if (!this.tables.containsKey(name) && this.tables.put(name, table) == null) {
            return table;
        }
        throw new IllegalNameException(this.resources().getString((short)13, name));
    }

    final Resources resources() {
        return Resources.forLocale(this.database.listeners.getLocale());
    }

    final String internalError() {
        return this.resources().getString((short)6);
    }

    private void warning(short key, Object argument) {
        this.warnings.add(Resources.formatInternational(key, argument));
    }

    final Collection<Table> finish() throws DataStoreException {
        for (Table table : this.tables.values()) {
            table.setDeferredSearchTables(this, this.tables);
        }
        for (ResourceInternationalString warning : this.warnings) {
            this.database.log(warning.toLogRecord(Level.WARNING));
        }
        return this.tables.values();
    }

    final ValueGetter<?> setValueGetter(Column column) {
        ValueGetter<Object> getter = this.database.getMapping(column);
        if (getter == null) {
            getter = this.database.getDefaultMapping();
            this.warning((short)4, column.typeName);
        }
        column.valueGetter = getter;
        return getter;
    }
}

