/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class NodeGeometryBuilder
implements Consumer<Entity> {
    private final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);

    @Override
    public void accept(Entity entity) {
        if (entity instanceof Node) {
            Node node = (Node)entity;
            Point point = this.geometryFactory.createPoint(new Coordinate(node.getLon().doubleValue(), node.getLat().doubleValue()));
            node.setGeometry((Geometry)point);
        }
    }
}

