/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.v2.api.records.Counter;
import org.apache.hadoop.mapreduce.v2.api.records.CounterGroup;
import org.apache.hadoop.mapreduce.v2.api.records.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.CounterGroupPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.CounterPBImpl;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoBase;

public class CountersPBImpl
extends ProtoBase<MRProtos.CountersProto>
implements Counters {
    MRProtos.CountersProto proto = MRProtos.CountersProto.getDefaultInstance();
    MRProtos.CountersProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, CounterGroup> counterGroups = null;

    public CountersPBImpl() {
        this.builder = MRProtos.CountersProto.newBuilder();
    }

    public CountersPBImpl(MRProtos.CountersProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public MRProtos.CountersProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.counterGroups != null) {
            this.addCounterGroupsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = MRProtos.CountersProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Map<String, CounterGroup> getAllCounterGroups() {
        this.initCounterGroups();
        return this.counterGroups;
    }

    @Override
    public CounterGroup getCounterGroup(String key) {
        this.initCounterGroups();
        return this.counterGroups.get(key);
    }

    @Override
    public Counter getCounter(Enum<?> key) {
        CounterGroup group = this.getCounterGroup(key.getDeclaringClass().getName());
        return group == null ? null : group.getCounter(key.name());
    }

    @Override
    public void incrCounter(Enum<?> key, long amount) {
        String groupName = key.getDeclaringClass().getName();
        if (this.getCounterGroup(groupName) == null) {
            CounterGroupPBImpl cGrp = new CounterGroupPBImpl();
            cGrp.setName(groupName);
            cGrp.setDisplayName(groupName);
            this.setCounterGroup(groupName, cGrp);
        }
        if (this.getCounterGroup(groupName).getCounter(key.name()) == null) {
            CounterPBImpl c = new CounterPBImpl();
            c.setName(key.name());
            c.setDisplayName(key.name());
            c.setValue(0L);
            this.getCounterGroup(groupName).setCounter(key.name(), c);
        }
        Counter counter = this.getCounterGroup(groupName).getCounter(key.name());
        counter.setValue(counter.getValue() + amount);
    }

    private void initCounterGroups() {
        if (this.counterGroups != null) {
            return;
        }
        MRProtos.CountersProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<MRProtos.StringCounterGroupMapProto> list = p.getCounterGroupsList();
        this.counterGroups = new HashMap<String, CounterGroup>();
        for (MRProtos.StringCounterGroupMapProto c : list) {
            this.counterGroups.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    @Override
    public void addAllCounterGroups(Map<String, CounterGroup> counterGroups) {
        if (counterGroups == null) {
            return;
        }
        this.initCounterGroups();
        this.counterGroups.putAll(counterGroups);
    }

    private void addCounterGroupsToProto() {
        this.maybeInitBuilder();
        this.builder.clearCounterGroups();
        if (this.counterGroups == null) {
            return;
        }
        Iterable<MRProtos.StringCounterGroupMapProto> iterable = new Iterable<MRProtos.StringCounterGroupMapProto>(){

            @Override
            public Iterator<MRProtos.StringCounterGroupMapProto> iterator() {
                return new Iterator<MRProtos.StringCounterGroupMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = CountersPBImpl.this.counterGroups.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public MRProtos.StringCounterGroupMapProto next() {
                        String key = this.keyIter.next();
                        return MRProtos.StringCounterGroupMapProto.newBuilder().setKey(key).setValue(CountersPBImpl.this.convertToProtoFormat((CounterGroup)CountersPBImpl.this.counterGroups.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllCounterGroups((Iterable<? extends MRProtos.StringCounterGroupMapProto>)iterable);
    }

    @Override
    public void setCounterGroup(String key, CounterGroup val) {
        this.initCounterGroups();
        this.counterGroups.put(key, val);
    }

    @Override
    public void removeCounterGroup(String key) {
        this.initCounterGroups();
        this.counterGroups.remove(key);
    }

    @Override
    public void clearCounterGroups() {
        this.initCounterGroups();
        this.counterGroups.clear();
    }

    private CounterGroupPBImpl convertFromProtoFormat(MRProtos.CounterGroupProto p) {
        return new CounterGroupPBImpl(p);
    }

    private MRProtos.CounterGroupProto convertToProtoFormat(CounterGroup t) {
        return ((CounterGroupPBImpl)t).getProto();
    }
}

