/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.iploc.InetAddressUtils;
import org.apache.baremaps.iploc.InetRange;
import org.apache.baremaps.iploc.IpLocObject;
import org.apache.baremaps.iploc.IpLocPrecision;
import org.apache.baremaps.openstreetmap.stream.StreamUtils;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpLocRepository {
    private static final String DROP_TABLE = "DROP TABLE IF EXISTS inetnum_locations;\n";
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS inetnum_locations (\n    id integer PRIMARY KEY,\n    geocoder_input text,\n    ip_start blob,\n    ip_end blob,\n    longitude real,\n    latitude real,\n    network text,\n    country text,\n    source text,\n    precision text\n)";
    private static final String CREATE_INDEX = "CREATE INDEX inetnum_locations_ips ON inetnum_locations (ip_start,ip_end);\n";
    private static final String INSERT_SQL = "INSERT INTO inetnum_locations(geocoder_input, ip_start, ip_end, longitude, latitude, network, country, source, precision)\nVALUES(?,?,?,?,?,?,?,?,?);\n";
    private static final String SELECT_ALL_SQL = "SELECT id, geocoder_input, ip_start, ip_end, longitude, latitude, network, country, source, precision\nFROM inetnum_locations;\n";
    private static final String SELECT_ALL_BY_IP_SQL = "SELECT id, geocoder_input, ip_start, ip_end, longitude, latitude, network, country, source, precision\nFROM inetnum_locations\nWHERE ip_start <= ? AND ip_end >= ?\nORDER BY ip_start DESC, ip_end ASC;\n";
    private static final Logger logger = LoggerFactory.getLogger(IpLocRepository.class);
    private final DataSource dataSource;

    public IpLocRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void dropTable() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(DROP_TABLE);){
            statement.execute();
        }
        catch (SQLException e) {
            logger.error("Unable to drop inetnum locations table", (Throwable)e);
        }
    }

    public void createTable() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(CREATE_TABLE);){
            statement.execute();
        }
        catch (SQLException e) {
            logger.error("Unable to create inetnum locations table", (Throwable)e);
        }
    }

    public void createIndex() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(CREATE_INDEX);){
            statement.execute();
        }
        catch (SQLException e) {
            logger.error("Unable to create inetnum locations index", (Throwable)e);
        }
    }

    public List<IpLocObject> findAll() {
        ArrayList<IpLocObject> results = new ArrayList<IpLocObject>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(SELECT_ALL_SQL);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                results.add(this.resultSetToPojo(resultSet));
            }
        }
        catch (SQLException e) {
            logger.error("Unable to select inetnum locations", (Throwable)e);
        }
        return results;
    }

    private IpLocObject resultSetToPojo(ResultSet resultSet) throws SQLException {
        return new IpLocObject(resultSet.getString("geocoder_input"), new InetRange(InetAddressUtils.fromByteArray(resultSet.getBytes("ip_start")), InetAddressUtils.fromByteArray(resultSet.getBytes("ip_end"))), new Coordinate(resultSet.getDouble("longitude"), resultSet.getDouble("latitude")), resultSet.getString("network"), resultSet.getString("country"), resultSet.getString("source"), IpLocPrecision.valueOf(resultSet.getString("precision")));
    }

    public List<IpLocObject> findByInetAddress(InetAddress inetAddress) {
        ArrayList<IpLocObject> ipLocObjects = new ArrayList<IpLocObject>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(SELECT_ALL_BY_IP_SQL);){
            statement.setBytes(1, inetAddress.getAddress());
            statement.setBytes(2, inetAddress.getAddress());
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ipLocObjects.add(this.resultSetToPojo(resultSet));
                }
            }
        }
        catch (SQLException e) {
            logger.error("Unable to select inetnum locations", (Throwable)e);
        }
        return ipLocObjects;
    }

    public void save(List<IpLocObject> ipLocObjects) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(INSERT_SQL);){
            connection.setAutoCommit(false);
            for (IpLocObject ipLocObject : ipLocObjects) {
                statement.setString(1, ipLocObject.geocoderInput());
                statement.setBytes(2, ipLocObject.inetRange().start().getAddress());
                statement.setBytes(3, ipLocObject.inetRange().end().getAddress());
                statement.setDouble(4, ipLocObject.coordinate().getX());
                statement.setDouble(5, ipLocObject.coordinate().getY());
                statement.setString(6, ipLocObject.network());
                statement.setString(7, ipLocObject.country());
                statement.setString(8, ipLocObject.source());
                statement.setString(9, ipLocObject.precision().toString());
                statement.addBatch();
            }
            statement.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            logger.error("Unable to save data", (Throwable)e);
        }
    }

    public void save(Stream<IpLocObject> ipLocObjects) {
        StreamUtils.partition(ipLocObjects, (int)100).forEach(this::save);
    }
}

