/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

public class ImageRectangle {
    private int left;
    private int right;
    private int top;
    private int bottom;

    public ImageRectangle(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public ImageRectangle(ImageRectangle rectangle) {
        this(rectangle.getLeft(), rectangle.getTop(), rectangle.getRight(), rectangle.getBottom());
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public boolean isValid() {
        return this.left < this.right && this.top < this.bottom;
    }

    public boolean isValidAllowEmpty() {
        return this.left <= this.right && this.top <= this.bottom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bottom;
        result = 31 * result + this.left;
        result = 31 * result + this.right;
        result = 31 * result + this.top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageRectangle other = (ImageRectangle)obj;
        if (this.bottom != other.bottom) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.top == other.top;
    }
}

