/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.nio.MappedByteBuffer;
import org.apache.baremaps.shapefile.DBaseDataType;

public class DBaseFieldDescriptor {
    private byte[] fieldName = new byte[11];
    private String stringFieldName;
    private DBaseDataType fieldType;
    private byte[] fieldAddress = new byte[4];
    private byte fieldLength;
    private byte fieldDecimalCount;
    private byte[] dbasePlusLanReserved2 = new byte[2];
    private byte workAreaID;
    private byte[] dbasePlusLanReserved3 = new byte[2];
    private byte setFields;

    public DBaseFieldDescriptor(MappedByteBuffer byteBuffer) {
        byteBuffer.get(this.fieldName);
        char dt = (char)byteBuffer.get();
        this.fieldType = DBaseDataType.valueOfDataType(dt);
        byteBuffer.get(this.fieldAddress);
        this.fieldLength = byteBuffer.get();
        this.fieldDecimalCount = byteBuffer.get();
        byteBuffer.getShort();
        byteBuffer.get(this.dbasePlusLanReserved2);
        this.workAreaID = byteBuffer.get();
        byteBuffer.get(this.dbasePlusLanReserved3);
        this.setFields = byteBuffer.get();
        byte[] data = new byte[6];
        byteBuffer.get(data);
    }

    public int getDecimalCount() {
        return Byte.toUnsignedInt(this.fieldDecimalCount);
    }

    public int getLength() {
        return Byte.toUnsignedInt(this.fieldLength);
    }

    public String getName() {
        if (this.stringFieldName == null) {
            int length;
            for (length = this.fieldName.length; length != 0 && Byte.toUnsignedInt(this.fieldName[length - 1]) <= 32; --length) {
            }
            this.stringFieldName = new String(this.fieldName, 0, length);
        }
        return this.stringFieldName;
    }

    public DBaseDataType getType() {
        return this.fieldType;
    }
}

