/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.polygonize.EdgeRing;
import org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge;
import org.locationtech.jts.operation.polygonize.PolygonizeEdge;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.DirectedEdgeStar;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;
import org.locationtech.jts.util.Assert;

class PolygonizeGraph
extends PlanarGraph {
    private GeometryFactory factory;

    private static int getDegreeNonDeleted(Node node) {
        List<DirectedEdge> edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge polygonizeDirectedEdge : edges) {
            if (polygonizeDirectedEdge.isMarked()) continue;
            ++degree;
        }
        return degree;
    }

    private static int getDegree(Node node, long label) {
        List<DirectedEdge> edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge polygonizeDirectedEdge : edges) {
            if (polygonizeDirectedEdge.getLabel() != label) continue;
            ++degree;
        }
        return degree;
    }

    public static void deleteAllEdges(Node node) {
        List<DirectedEdge> edges = node.getOutEdges().getEdges();
        for (PolygonizeDirectedEdge polygonizeDirectedEdge : edges) {
            polygonizeDirectedEdge.setMarked(true);
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
            if (sym == null) continue;
            sym.setMarked(true);
        }
    }

    public PolygonizeGraph(GeometryFactory factory) {
        this.factory = factory;
    }

    public void addEdge(LineString line) {
        if (line.isEmpty()) {
            return;
        }
        Coordinate[] linePts = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        if (linePts.length < 2) {
            return;
        }
        Coordinate startPt = linePts[0];
        Coordinate endPt = linePts[linePts.length - 1];
        Node nStart = this.getNode(startPt);
        Node nEnd = this.getNode(endPt);
        PolygonizeDirectedEdge de0 = new PolygonizeDirectedEdge(nStart, nEnd, linePts[1], true);
        PolygonizeDirectedEdge de1 = new PolygonizeDirectedEdge(nEnd, nStart, linePts[linePts.length - 2], false);
        PolygonizeEdge edge = new PolygonizeEdge(line);
        edge.setDirectedEdges(de0, de1);
        this.add(edge);
    }

    private Node getNode(Coordinate pt) {
        Node node = this.findNode(pt);
        if (node == null) {
            node = new Node(pt);
            this.add(node);
        }
        return node;
    }

    private void computeNextCWEdges() {
        Iterator iNode = this.nodeIterator();
        while (iNode.hasNext()) {
            Node node = (Node)iNode.next();
            PolygonizeGraph.computeNextCWEdges(node);
        }
    }

    private void convertMaximalToMinimalEdgeRings(List<PolygonizeDirectedEdge> ringEdges) {
        for (PolygonizeDirectedEdge de : ringEdges) {
            long label;
            List<Node> intNodes = PolygonizeGraph.findIntersectionNodes(de, label = de.getLabel());
            if (intNodes == null) continue;
            for (Node node : intNodes) {
                PolygonizeGraph.computeNextCCWEdges(node, label);
            }
        }
    }

    private static List<Node> findIntersectionNodes(PolygonizeDirectedEdge startDE, long label) {
        PolygonizeDirectedEdge de = startDE;
        ArrayList<Node> intNodes = null;
        do {
            Node node;
            if (PolygonizeGraph.getDegree(node = de.getFromNode(), label) > 1) {
                if (intNodes == null) {
                    intNodes = new ArrayList<Node>();
                }
                intNodes.add(node);
            }
            Assert.isTrue((de = de.getNext()) != null, "found null DE in ring");
            Assert.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
        } while (de != startDE);
        return intNodes;
    }

    public List<EdgeRing> getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.label(this.dirEdges, -1L);
        List<PolygonizeDirectedEdge> maximalRings = PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        this.convertMaximalToMinimalEdgeRings(maximalRings);
        ArrayList<EdgeRing> edgeRingList = new ArrayList<EdgeRing>();
        for (PolygonizeDirectedEdge de : this.dirEdges) {
            if (de.isMarked() || de.isInRing()) continue;
            EdgeRing er = this.findEdgeRing(de);
            edgeRingList.add(er);
        }
        return edgeRingList;
    }

    private static List<PolygonizeDirectedEdge> findLabeledEdgeRings(Collection<PolygonizeDirectedEdge> dirEdges) {
        ArrayList<PolygonizeDirectedEdge> edgeRingStarts = new ArrayList<PolygonizeDirectedEdge>();
        long currLabel = 1L;
        for (PolygonizeDirectedEdge de : dirEdges) {
            if (de.isMarked() || de.getLabel() >= 0L) continue;
            edgeRingStarts.add(de);
            List<PolygonizeDirectedEdge> edges = EdgeRing.findDirEdgesInRing(de);
            PolygonizeGraph.label(edges, currLabel);
            ++currLabel;
        }
        return edgeRingStarts;
    }

    public List<LineString> deleteCutEdges() {
        this.computeNextCWEdges();
        PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        ArrayList<LineString> cutLines = new ArrayList<LineString>();
        for (PolygonizeDirectedEdge de : this.dirEdges) {
            if (de.isMarked()) continue;
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
            if (de.getLabel() != sym.getLabel()) continue;
            de.setMarked(true);
            sym.setMarked(true);
            PolygonizeEdge e = (PolygonizeEdge)de.getEdge();
            cutLines.add(e.getLine());
        }
        return cutLines;
    }

    private static void label(Collection<?> dirEdges, long label) {
        for (PolygonizeDirectedEdge de : dirEdges) {
            de.setLabel(label);
        }
    }

    private static void computeNextCWEdges(Node node) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge startDE = null;
        DirectedEdge prevDE = null;
        for (PolygonizeDirectedEdge polygonizeDirectedEdge : deStar.getEdges()) {
            if (polygonizeDirectedEdge.isMarked()) continue;
            if (startDE == null) {
                startDE = polygonizeDirectedEdge;
            }
            if (prevDE != null) {
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
                sym.setNext(polygonizeDirectedEdge);
            }
            prevDE = polygonizeDirectedEdge;
        }
        if (prevDE != null) {
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
            sym.setNext(startDE);
        }
    }

    private static void computeNextCCWEdges(Node node, long label) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge firstOutDE = null;
        PolygonizeDirectedEdge prevInDE = null;
        List<DirectedEdge> edges = deStar.getEdges();
        for (int i = edges.size() - 1; i >= 0; --i) {
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)edges.get(i);
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
            PolygonizeDirectedEdge outDE = null;
            if (de.getLabel() == label) {
                outDE = de;
            }
            PolygonizeDirectedEdge inDE = null;
            if (sym.getLabel() == label) {
                inDE = sym;
            }
            if (outDE == null && inDE == null) continue;
            if (inDE != null) {
                prevInDE = inDE;
            }
            if (outDE == null) continue;
            if (prevInDE != null) {
                prevInDE.setNext(outDE);
                prevInDE = null;
            }
            if (firstOutDE != null) continue;
            firstOutDE = outDE;
        }
        if (prevInDE != null) {
            Assert.isTrue(firstOutDE != null);
            prevInDE.setNext(firstOutDE);
        }
    }

    private EdgeRing findEdgeRing(PolygonizeDirectedEdge startDE) {
        EdgeRing er = new EdgeRing(this.factory);
        er.build(startDE);
        return er;
    }

    public List<LineString> deleteDangles() {
        List nodesToRemove = this.findNodesOfDegree(1);
        ArrayList<LineString> dangleLines = new ArrayList<LineString>();
        Stack nodeStack = new Stack();
        Iterator i = nodesToRemove.iterator();
        while (i.hasNext()) {
            nodeStack.push(i.next());
        }
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            PolygonizeGraph.deleteAllEdges(node);
            List<DirectedEdge> nodeOutEdges = node.getOutEdges().getEdges();
            for (PolygonizeDirectedEdge polygonizeDirectedEdge : nodeOutEdges) {
                polygonizeDirectedEdge.setMarked(true);
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
                if (sym != null) {
                    sym.setMarked(true);
                }
                PolygonizeEdge e = (PolygonizeEdge)polygonizeDirectedEdge.getEdge();
                dangleLines.add(e.getLine());
                Node toNode = polygonizeDirectedEdge.getToNode();
                if (PolygonizeGraph.getDegreeNonDeleted(toNode) != 1) continue;
                nodeStack.push(toNode);
            }
        }
        return dangleLines;
    }
}

