/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ArchivedExecutionVertex
implements AccessExecutionVertex,
Serializable {
    private static final long serialVersionUID = -6708241535015028576L;
    private final int subTaskIndex;
    private final ExecutionHistory executionHistory;
    private final String taskNameWithSubtask;
    private final ArchivedExecution currentExecution;
    private final Collection<AccessExecution> currentExecutions;

    public ArchivedExecutionVertex(ExecutionVertex vertex) {
        this.subTaskIndex = vertex.getParallelSubtaskIndex();
        this.executionHistory = ArchivedExecutionVertex.getCopyOfExecutionHistory(vertex);
        this.taskNameWithSubtask = vertex.getTaskNameWithSubtaskIndex();
        Execution vertexCurrentExecution = vertex.getCurrentExecutionAttempt();
        ArrayList<ArchivedExecution> currentExecutionList = new ArrayList<ArchivedExecution>(vertex.getCurrentExecutions().size());
        this.currentExecution = vertexCurrentExecution.archive();
        currentExecutionList.add(this.currentExecution);
        for (Execution execution : vertex.getCurrentExecutions()) {
            if (execution == vertexCurrentExecution) continue;
            currentExecutionList.add(execution.archive());
        }
        this.currentExecutions = Collections.unmodifiableList(currentExecutionList);
    }

    @VisibleForTesting
    public ArchivedExecutionVertex(int subTaskIndex, String taskNameWithSubtask, ArchivedExecution currentExecution, ExecutionHistory executionHistory) {
        this.subTaskIndex = subTaskIndex;
        this.taskNameWithSubtask = (String)Preconditions.checkNotNull((Object)taskNameWithSubtask);
        this.currentExecution = (ArchivedExecution)Preconditions.checkNotNull((Object)currentExecution);
        this.executionHistory = (ExecutionHistory)Preconditions.checkNotNull((Object)executionHistory);
        this.currentExecutions = Collections.singletonList(currentExecution);
    }

    @Override
    public String getTaskNameWithSubtaskIndex() {
        return this.taskNameWithSubtask;
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    @Override
    public ArchivedExecution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    public Collection<AccessExecution> getCurrentExecutions() {
        return this.currentExecutions;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    @Override
    public Optional<ErrorInfo> getFailureInfo() {
        return this.currentExecution.getFailureInfo();
    }

    @Override
    public TaskManagerLocation getCurrentAssignedResourceLocation() {
        return this.currentExecution.getAssignedResourceLocation();
    }

    @Override
    public ExecutionHistory getExecutionHistory() {
        return this.executionHistory;
    }

    static ExecutionHistory getCopyOfExecutionHistory(ExecutionVertex executionVertex) {
        return new ExecutionHistory(executionVertex.getExecutionHistory());
    }
}

