/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.writer;

import java.io.IOException;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.spark.SparkInternalRowCastWrapper;
import org.apache.amoro.spark.writer.RowLevelWriter;
import org.apache.amoro.spark.writer.WriteTaskCommit;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class SimpleRowLevelDataWriter
implements RowLevelWriter<InternalRow> {
    private final TaskWriter<InternalRow> insertWriter;
    private final TaskWriter<InternalRow> deleteWrite;
    private final StructType schema;
    private final boolean isKeyedTable;

    public SimpleRowLevelDataWriter(TaskWriter<InternalRow> insertWriter, TaskWriter<InternalRow> deleteWrite, StructType schema, boolean isKeyedTable) {
        this.insertWriter = insertWriter;
        this.deleteWrite = deleteWrite;
        this.schema = schema;
        this.isKeyedTable = isKeyedTable;
    }

    @Override
    public void delete(InternalRow row) throws IOException {
        this.deleteWrite.write((Object)new SparkInternalRowCastWrapper(row, ChangeAction.DELETE, this.schema));
    }

    @Override
    public void update(InternalRow updateBefore, InternalRow updateAfter) throws IOException {
        SparkInternalRowCastWrapper insert;
        SparkInternalRowCastWrapper delete;
        if (this.isKeyedTable) {
            delete = new SparkInternalRowCastWrapper(updateBefore, ChangeAction.UPDATE_BEFORE, this.schema);
            insert = new SparkInternalRowCastWrapper(updateAfter, ChangeAction.UPDATE_AFTER, this.schema);
        } else {
            delete = new SparkInternalRowCastWrapper(updateBefore, ChangeAction.DELETE, this.schema);
            insert = new SparkInternalRowCastWrapper(updateAfter, ChangeAction.INSERT, this.schema);
        }
        if (!this.rowIsAllNull(delete)) {
            this.insertWriter.write((Object)delete);
        }
        this.insertWriter.write((Object)insert);
    }

    private boolean rowIsAllNull(SparkInternalRowCastWrapper row) {
        boolean isAllNull = true;
        for (int i = 0; i < row.getSchema().size(); ++i) {
            if (row.getRow().isNullAt(i)) continue;
            isAllNull = false;
        }
        return isAllNull;
    }

    @Override
    public void insert(InternalRow row) throws IOException {
        this.insertWriter.write((Object)new SparkInternalRowCastWrapper(row, ChangeAction.INSERT, this.schema));
    }

    public WriterCommitMessage commit() throws IOException {
        WriteResult insert = this.insertWriter.complete();
        WriteResult delete = this.deleteWrite.complete();
        return new WriteTaskCommit.Builder().addDataFiles(insert.dataFiles()).addDataFiles(delete.dataFiles()).addDeleteFiles(insert.deleteFiles()).addDeleteFiles(delete.deleteFiles()).build();
    }

    public void abort() throws IOException {
        if (this.insertWriter != null) {
            this.insertWriter.abort();
        }
        if (this.deleteWrite != null) {
            this.deleteWrite.abort();
        }
    }

    public void close() throws IOException {
        if (this.insertWriter != null) {
            this.insertWriter.close();
        }
        if (this.deleteWrite != null) {
            this.deleteWrite.close();
        }
    }
}

