/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.writer;

import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.spark.writer.KeyedSparkBatchWrite;
import org.apache.amoro.spark.writer.UnkeyedSparkBatchWrite;
import org.apache.amoro.spark.writer.WriteMode;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.SupportsDynamicOverwrite;
import org.apache.spark.sql.connector.write.SupportsOverwrite;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class MixedFormatSparkWriteBuilder
implements WriteBuilder,
SupportsDynamicOverwrite,
SupportsOverwrite {
    protected final CaseInsensitiveStringMap options;
    protected Expression overwriteExpr = null;
    private WriteMode writeMode = WriteMode.APPEND;
    private final MixedTable table;
    private final LogicalWriteInfo info;
    private final MixedFormatCatalog catalog;

    public MixedFormatSparkWriteBuilder(MixedTable table, LogicalWriteInfo info, MixedFormatCatalog catalog) {
        this.options = info.options();
        if (this.options.containsKey((Object)"write-mode")) {
            this.writeMode = WriteMode.getWriteMode(this.options.get((Object)"write-mode"));
        }
        this.table = table;
        this.info = info;
        this.catalog = catalog;
    }

    public WriteBuilder overwriteDynamicPartitions() {
        Preconditions.checkState((this.overwriteExpr == null ? 1 : 0) != 0, (String)"Cannot overwrite dynamically and by filter: %s", (Object)this.overwriteExpr);
        this.writeMode = WriteMode.OVERWRITE_DYNAMIC;
        return this;
    }

    public WriteBuilder overwrite(Filter[] filters) {
        this.overwriteExpr = SparkFilters.convert((Filter[])filters);
        String overwriteMode = (String)this.options.getOrDefault((Object)"overwrite-mode", (Object)"null");
        this.writeMode = this.overwriteExpr == Expressions.alwaysTrue() && "dynamic".equals(overwriteMode) ? WriteMode.OVERWRITE_DYNAMIC : WriteMode.OVERWRITE_BY_FILTER;
        return this;
    }

    public Write build() {
        if (this.table.isKeyedTable()) {
            return new KeyedSparkBatchWrite(this.table.asKeyedTable(), this.info, this.catalog){

                public BatchWrite toBatch() {
                    switch (MixedFormatSparkWriteBuilder.this.writeMode) {
                        case APPEND: {
                            return this.asBatchAppend();
                        }
                        case OVERWRITE_BY_FILTER: {
                            return this.asOverwriteByFilter(MixedFormatSparkWriteBuilder.this.overwriteExpr);
                        }
                        case OVERWRITE_DYNAMIC: {
                            return this.asDynamicOverwrite();
                        }
                        case UPSERT: {
                            return this.asUpsertWrite();
                        }
                    }
                    throw new UnsupportedOperationException("unsupported write mode: " + (Object)((Object)MixedFormatSparkWriteBuilder.this.writeMode));
                }
            };
        }
        return new UnkeyedSparkBatchWrite(this.table.asUnkeyedTable(), this.info, this.catalog){

            public BatchWrite toBatch() {
                switch (MixedFormatSparkWriteBuilder.this.writeMode) {
                    case APPEND: {
                        return this.asBatchAppend();
                    }
                    case OVERWRITE_BY_FILTER: {
                        return this.asOverwriteByFilter(MixedFormatSparkWriteBuilder.this.overwriteExpr);
                    }
                    case OVERWRITE_DYNAMIC: {
                        return this.asDynamicOverwrite();
                    }
                    case UPSERT: {
                        return this.asUpsertWrite();
                    }
                }
                throw new UnsupportedOperationException("unsupported write mode: " + (Object)((Object)MixedFormatSparkWriteBuilder.this.writeMode));
            }
        };
    }

    public static interface MixedFormatWrite {
        public BatchWrite asBatchAppend();

        public BatchWrite asDynamicOverwrite();

        public BatchWrite asOverwriteByFilter(Expression var1);

        public BatchWrite asUpsertWrite();
    }
}

