/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.\n      The function returns NULL if at least one of the input parameters is NULL.\n      When both of the input parameters are not NULL and day_of_week is an invalid input,\n      the function throws IllegalArgumentException if `spark.sql.ansi.enabled` is set to true, otherwise NULL.\n      ", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0014)\u0001VB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011\t(\t\u000b\t\u0004A\u0011\t(\t\u000bm\u0003A\u0011A2\t\u000b\u0019\u0004A\u0011I4\t\u000be\u0004A\u0011\t>\t\u000by\u0004A\u0011\t,\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002F\u0001!\t&a\u0012\t\u000f\u0005U\u0003\u0001\"\u0011\u0002\u0014!9\u0011q\u000b\u0001\u0005R\u0005e\u0003\"CA2\u0001\u0005\u0005I\u0011AA3\u0011%\ti\u0007AI\u0001\n\u0003\ty\u0007C\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002p!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b\u0003\u0011\u0011!C!\u0003\u001fC\u0011\"a(\u0001\u0003\u0003%\t!!)\t\u0013\u0005%\u0006!!A\u0005\u0002\u0005-\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\u001eI\u0011Q\u001e\u0015\u0002\u0002#\u0005\u0011q\u001e\u0004\tO!\n\t\u0011#\u0001\u0002r\"11l\bC\u0001\u0003\u007fD\u0011B!\u0001 \u0003\u0003%)Ea\u0001\t\u0013\t\u0015q$!A\u0005\u0002\n\u001d\u0001\"\u0003B\b?E\u0005I\u0011AAE\u0011%\u0011\tbHA\u0001\n\u0003\u0013\u0019\u0002C\u0005\u0003&}\t\n\u0011\"\u0001\u0002\n\"I!qE\u0010\u0002\u0002\u0013%!\u0011\u0006\u0002\b\u001d\u0016DH\u000fR1z\u0015\tI#&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0016-\u0003!\u0019\u0017\r^1msN$(BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011C\u0002\u00017uu\"%\n\u0005\u00028q5\t\u0001&\u0003\u0002:Q\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003omJ!\u0001\u0010\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AP!\u000f\u0005]z\u0014B\u0001!)\u0003\u001d\u0001\u0018mY6bO\u0016L!AQ\"\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0001\t\u000b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\b!J|G-^2u!\t)5*\u0003\u0002M\r\na1+\u001a:jC2L'0\u00192mK\u0006I1\u000f^1si\u0012\u000bG/Z\u000b\u0002\u001fB\u0011q\u0007U\u0005\u0003#\"\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003)\u0019H/\u0019:u\t\u0006$X\rI\u0001\nI\u0006LxJZ,fK.\f!\u0002Z1z\u001f\u001a<V-Z6!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003]\u0003\"!\u0012-\n\u0005e3%a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tusv\f\u0019\t\u0003o\u0001AQ!T\u0004A\u0002=CQaU\u0004A\u0002=Cq!V\u0004\u0011\u0002\u0003\u0007q+\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$HcA/eK\")\u0011M\u0003a\u0001\u001f\")!M\u0003a\u0001\u001f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003!\u00042!\u001b9t\u001d\tQwN\u0004\u0002l]6\tAN\u0003\u0002ni\u00051AH]8pizJ\u0011aR\u0005\u0003\u0001\u001aK!!\u001d:\u0003\u0007M+\u0017O\u0003\u0002A\rB\u0011Ao^\u0007\u0002k*\u0011a\u000fL\u0001\u0006if\u0004Xm]\u0005\u0003qV\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001f\t\u0003irL!!`;\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003\u0007\tI!!\u0004\u0011\u0007\u0015\u000b)!C\u0002\u0002\b\u0019\u00131!\u00118z\u0011\u001d\tYA\u0004a\u0001\u0003\u0007\tQa\u001d;beRDq!a\u0004\u000f\u0001\u0004\t\u0019!\u0001\u0004eCf|emV\u0001\u0012I\u0006$X\rV5nKV#\u0018\u000e\\\"mCN\u001cXCAA\u000b!\u0011\t9\"a\b\u000f\t\u0005e\u00111\u0004\t\u0003W\u001aK1!!\bG\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0004$\u0002\u001d9,\u0007\u0010\u001e#bs\u001e+gnQ8eKRQ\u0011QCA\u0015\u0003s\ti$!\u0011\t\u000f\u0005-\u0002\u00031\u0001\u0002.\u0005\u0011QM\u001e\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0015\u0002\u000f\r|G-Z4f]&!\u0011qGA\u0019\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u001e!\u0001\u0007\u0011QC\u0001\u000eI\u0006LxJZ,fK.$VM]7\t\u000f\u0005}\u0002\u00031\u0001\u0002\u0016\u0005\u00111\u000f\u001a\u0005\b\u0003\u0007\u0002\u0002\u0019AA\u000b\u0003\u0011!wn^*\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0017\u0003\u0013\n\u0019\u0006C\u0004\u0002LE\u0001\r!!\u0014\u0002\u0007\r$\b\u0010\u0005\u0003\u00020\u0005=\u0013\u0002BA)\u0003c\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002,E\u0001\r!!\f\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)Q,a\u0017\u0002`!1\u0011QL\nA\u0002=\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002bM\u0001\raT\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001di\u0016qMA5\u0003WBq!\u0014\u000b\u0011\u0002\u0003\u0007q\nC\u0004T)A\u0005\t\u0019A(\t\u000fU#\u0002\u0013!a\u0001/\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA9U\ry\u00151O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0010$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0017S3aVA:\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0015\u0001\u00026bm\u0006LA!!\t\u0002\u0016\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0015\t\u0004\u000b\u0006\u0015\u0016bAAT\r\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111AAW\u0011%\tyKGA\u0001\u0002\u0004\t\u0019+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0003b!a.\u0002>\u0006\rQBAA]\u0015\r\tYLR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA`\u0003s\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q+!2\t\u0013\u0005=F$!AA\u0002\u0005\r\u0011AB3rk\u0006d7\u000fF\u0002X\u0003\u0017D\u0011\"a,\u001e\u0003\u0003\u0005\r!a\u0001)'\u0001\ty-!6\u0002X\u0006m\u0017Q\\Aq\u0003G\f9/!;\u0011\u0007]\n\t.C\u0002\u0002T\"\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002Z\u0006\u0019)c\u0018$V\u001d\u000e{\u0006f\u001d;beR|F-\u0019;fY\u0001\"\u0017-_0pM~;X-Z6*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0019L'o\u001d;!I\u0006$X\rI<iS\u000eD\u0007%[:!Y\u0006$XM\u001d\u0011uQ\u0006t\u0007\u0005Y:uCJ$x\fZ1uK\u0002\u0004\u0013M\u001c3!]\u0006lW\r\u001a\u0011bg\u0002Jg\u000eZ5dCR,GM\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011bi\u0002bW-Y:uA=tW\rI8gAQDW\rI5oaV$\b\u0005]1sC6,G/\u001a:tA%\u001c\bET+M\u0019:R\u0001\u0005\t\u0011!A\u0001:\u0006.\u001a8!E>$\b\u000eI8gAQDW\rI5oaV$\b\u0005]1sC6,G/\u001a:tA\u0005\u0014X\r\t8pi\u0002rU\u000b\u0014'!C:$\u0007\u0005Z1z?>4wl^3fW\u0002J7\u000fI1oA%tg/\u00197jI\u0002Jg\u000e];uY)\u0001\u0003\u0005\t\u0011!AQDW\r\t4v]\u000e$\u0018n\u001c8!i\"\u0014xn^:!\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007%\u001b4!AN\u0004\u0018M]6/gFdg&\u00198tS:*g.\u00192mK\u0012\u0004\u0007%[:!g\u0016$\b\u0005^8!iJ,X\r\f\u0011pi\",'o^5tK\u0002rU\u000b\u0014'/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAp\u00039S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cUj\u0003'M\u00172i\u001db\u0003e\n+VO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192k5\u0002\u0014'\f\u001a1\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAs\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a;\u0002\u000bErSG\f\u0019\u0002\u000f9+\u0007\u0010\u001e#bsB\u0011qgH\n\u0005?\u0005M(\n\u0005\u0005\u0002v\u0006mxjT,^\u001b\t\t9PC\u0002\u0002z\u001a\u000bqA];oi&lW-\u0003\u0003\u0002~\u0006](!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011q^\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011S\u0001\u0006CB\u0004H.\u001f\u000b\b;\n%!1\u0002B\u0007\u0011\u0015i%\u00051\u0001P\u0011\u0015\u0019&\u00051\u0001P\u0011\u001d)&\u0005%AA\u0002]\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)B!\t\u0011\u000b\u0015\u00139Ba\u0007\n\u0007\teaI\u0001\u0004PaRLwN\u001c\t\u0007\u000b\nuqjT,\n\u0007\t}aI\u0001\u0004UkBdWm\r\u0005\t\u0005G!\u0013\u0011!a\u0001;\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t-\u0002\u0003BAJ\u0005[IAAa\f\u0002\u0016\n1qJ\u00196fGR\u0004")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$3() {
        return NextDay$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NextDay nextDay) {
        return NextDay$.MODULE$.unapply(nextDay);
    }

    public static boolean apply$default$3() {
        return NextDay$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NextDay>>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        try {
            int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        catch (IllegalArgumentException e) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.ansiIllegalArgumentError(e);
            }
            n = null;
        }
        return n;
    }

    private String dateTimeUtilClass() {
        return new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
    }

    private String nextDayGenCode(ExprCode ev, String dayOfWeekTerm, String sd, String dowS) {
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiIllegalArgumentError(e);" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("\n     |try {\n     |  int ").append(dayOfWeekTerm).append(" = ").append(this.dateTimeUtilClass()).append(".getDayOfWeekFromString(").append(dowS).append(");\n     |  ").append(ev.value()).append(" = ").append(this.dateTimeUtilClass()).append(".getNextDateForDayOfWeek(").append(sd).append(", ").append(dayOfWeekTerm).append(");\n     |} catch (IllegalArgumentException e) {\n     |  ").append(failOnErrorBranch).append("\n     |}\n     |").toString())).stripMargin();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, dowS) -> {
            String string;
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null) {
                    string = new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                } else {
                    try {
                        int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                        string = new StringBuilder(32).append(ev.value()).append(" = ").append(this.dateTimeUtilClass()).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekValue).append(");").toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        string = this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
                    }
                }
            } else {
                string = this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    @Override
    public NextDay withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        return new NextDay(startDate, dayOfWeek, failOnError);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.startDate();
                break;
            }
            case 1: {
                object = this.dayOfWeek();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != nextDay.failOnError()) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public NextDay(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

