/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.arrow.vectorized.BaseBatchReader;
import org.apache.iceberg.arrow.vectorized.VectorizedArrowReader;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.data.vectorized.ColumnVectorBuilder;
import org.apache.iceberg.util.Pair;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarBatchReader
extends BaseBatchReader<ColumnarBatch> {
    private final boolean hasIsDeletedColumn;
    private DeleteFilter<InternalRow> deletes = null;
    private long rowStartPosInBatch = 0L;

    public ColumnarBatchReader(List<VectorizedReader<?>> readers) {
        super(readers);
        this.hasIsDeletedColumn = readers.stream().anyMatch(reader -> reader instanceof VectorizedArrowReader.DeletedVectorReader);
    }

    public void setRowGroupInfo(PageReadStore pageStore, Map<ColumnPath, ColumnChunkMetaData> metaData, long rowPosition) {
        super.setRowGroupInfo(pageStore, metaData, rowPosition);
        this.rowStartPosInBatch = rowPosition;
    }

    public void setDeleteFilter(DeleteFilter<InternalRow> deleteFilter) {
        this.deletes = deleteFilter;
    }

    public final ColumnarBatch read(ColumnarBatch reuse, int numRowsToRead) {
        if (reuse == null) {
            this.closeVectors();
        }
        ColumnarBatch columnarBatch = new ColumnBatchLoader(numRowsToRead).loadDataToColumnBatch();
        this.rowStartPosInBatch += (long)numRowsToRead;
        return columnarBatch;
    }

    private class ColumnBatchLoader {
        private final int numRowsToRead;
        private int[] rowIdMapping;
        private boolean[] isDeleted;

        ColumnBatchLoader(int numRowsToRead) {
            Preconditions.checkArgument((numRowsToRead > 0 ? 1 : 0) != 0, (String)"Invalid number of rows to read: %s", (int)numRowsToRead);
            this.numRowsToRead = numRowsToRead;
            if (ColumnarBatchReader.this.hasIsDeletedColumn) {
                this.isDeleted = new boolean[numRowsToRead];
            }
        }

        ColumnarBatch loadDataToColumnBatch() {
            int numRowsUndeleted = this.initRowIdMapping();
            ColumnVector[] arrowColumnVectors = this.readDataToColumnVectors();
            ColumnarBatch newColumnarBatch = new ColumnarBatch(arrowColumnVectors);
            newColumnarBatch.setNumRows(numRowsUndeleted);
            if (this.hasEqDeletes()) {
                this.applyEqDelete(newColumnarBatch);
            }
            if (ColumnarBatchReader.this.hasIsDeletedColumn && this.rowIdMapping != null) {
                for (int i = 0; i < this.numRowsToRead; ++i) {
                    this.rowIdMapping[i] = i;
                }
                newColumnarBatch.setNumRows(this.numRowsToRead);
            }
            return newColumnarBatch;
        }

        ColumnVector[] readDataToColumnVectors() {
            ColumnVector[] arrowColumnVectors = new ColumnVector[ColumnarBatchReader.this.readers.length];
            ColumnVectorBuilder columnVectorBuilder = new ColumnVectorBuilder();
            for (int i = 0; i < ColumnarBatchReader.this.readers.length; ++i) {
                ((ColumnarBatchReader)ColumnarBatchReader.this).vectorHolders[i] = ColumnarBatchReader.this.readers[i].read(ColumnarBatchReader.this.vectorHolders[i], this.numRowsToRead);
                int numRowsInVector = ColumnarBatchReader.this.vectorHolders[i].numValues();
                Preconditions.checkState((numRowsInVector == this.numRowsToRead ? 1 : 0) != 0, (String)"Number of rows in the vector %s didn't match expected %s ", (int)numRowsInVector, (int)this.numRowsToRead);
                arrowColumnVectors[i] = columnVectorBuilder.withDeletedRows(this.rowIdMapping, this.isDeleted).build(ColumnarBatchReader.this.vectorHolders[i], numRowsInVector);
            }
            return arrowColumnVectors;
        }

        boolean hasEqDeletes() {
            return ColumnarBatchReader.this.deletes != null && ColumnarBatchReader.this.deletes.hasEqDeletes();
        }

        int initRowIdMapping() {
            Pair<int[], Integer> posDeleteRowIdMapping = this.posDelRowIdMapping();
            if (posDeleteRowIdMapping != null) {
                this.rowIdMapping = (int[])posDeleteRowIdMapping.first();
                return (Integer)posDeleteRowIdMapping.second();
            }
            this.rowIdMapping = this.initEqDeleteRowIdMapping();
            return this.numRowsToRead;
        }

        Pair<int[], Integer> posDelRowIdMapping() {
            if (ColumnarBatchReader.this.deletes != null && ColumnarBatchReader.this.deletes.hasPosDeletes()) {
                return this.buildPosDelRowIdMapping(ColumnarBatchReader.this.deletes.deletedRowPositions());
            }
            return null;
        }

        Pair<int[], Integer> buildPosDelRowIdMapping(PositionDeleteIndex deletedRowPositions) {
            if (deletedRowPositions == null) {
                return null;
            }
            int[] posDelRowIdMapping = new int[this.numRowsToRead];
            int currentRowId = 0;
            for (int originalRowId = 0; originalRowId < this.numRowsToRead; ++originalRowId) {
                if (!deletedRowPositions.isDeleted((long)originalRowId + ColumnarBatchReader.this.rowStartPosInBatch)) {
                    posDelRowIdMapping[currentRowId] = originalRowId;
                    ++currentRowId;
                    continue;
                }
                if (ColumnarBatchReader.this.hasIsDeletedColumn) {
                    this.isDeleted[originalRowId] = true;
                }
                ColumnarBatchReader.this.deletes.incrementDeleteCount();
            }
            if (currentRowId == this.numRowsToRead) {
                return null;
            }
            return Pair.of((Object)posDelRowIdMapping, (Object)currentRowId);
        }

        int[] initEqDeleteRowIdMapping() {
            int[] eqDeleteRowIdMapping = null;
            if (this.hasEqDeletes()) {
                eqDeleteRowIdMapping = new int[this.numRowsToRead];
                for (int i = 0; i < this.numRowsToRead; ++i) {
                    eqDeleteRowIdMapping[i] = i;
                }
            }
            return eqDeleteRowIdMapping;
        }

        void applyEqDelete(ColumnarBatch columnarBatch) {
            Iterator it = columnarBatch.rowIterator();
            int rowId = 0;
            int currentRowId = 0;
            while (it.hasNext()) {
                InternalRow row = (InternalRow)it.next();
                if (ColumnarBatchReader.this.deletes.eqDeletedRowFilter().test(row)) {
                    this.rowIdMapping[currentRowId] = this.rowIdMapping[rowId];
                    ++currentRowId;
                } else {
                    if (ColumnarBatchReader.this.hasIsDeletedColumn) {
                        this.isDeleted[this.rowIdMapping[rowId]] = true;
                    }
                    ColumnarBatchReader.this.deletes.incrementDeleteCount();
                }
                ++rowId;
            }
            columnarBatch.setNumRows(currentRowId);
        }
    }
}

