/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.BooleanGauge;
import org.apache.ignite.internal.processors.metric.impl.BooleanMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.DoubleGauge;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.IntGauge;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderWithDelegateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongGauge;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.metric.impl.ObjectGauge;
import org.apache.ignite.internal.processors.metric.impl.ObjectMetricImpl;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.metric.MetricRegistry;
import org.apache.ignite.spi.metric.Metric;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricRegistryImpl
implements MetricRegistry {
    private String regName;
    private IgniteLogger log;
    private final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();
    private final Function<String, Long> hitRateCfgProvider;
    private final Function<String, long[]> histogramCfgProvider;

    public MetricRegistryImpl(String regName, Function<String, Long> hitRateCfgProvider, Function<String, long[]> histogramCfgProvider, IgniteLogger log) {
        this.regName = regName;
        this.log = log;
        this.hitRateCfgProvider = hitRateCfgProvider;
        this.histogramCfgProvider = histogramCfgProvider;
    }

    @Override
    @Nullable
    public <M extends Metric> M findMetric(String name) {
        return (M)this.metrics.get(name);
    }

    public void reset() {
        for (Metric m : this.metrics.values()) {
            m.reset();
        }
    }

    public <T> ObjectMetricImpl<T> objectMetric(String name, Class<T> type, @Nullable String desc) {
        return this.addMetric(name, new ObjectMetricImpl<T>(MetricUtils.metricName(this.regName, name), desc, type));
    }

    @Override
    @NotNull
    public Iterator<Metric> iterator() {
        return this.metrics.values().iterator();
    }

    public void register(Metric metric) {
        assert (((String)MetricUtils.fromFullName(metric.name()).get1()).equals(this.regName));
        this.addMetric((String)MetricUtils.fromFullName(metric.name()).get2(), metric);
    }

    @Override
    public void remove(String name) {
        this.metrics.remove(name);
    }

    @Override
    public void register(String name, BooleanSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new BooleanGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    @Override
    public void register(String name, DoubleSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new DoubleGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    @Override
    public void register(String name, IntSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new IntGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    @Override
    public void register(String name, LongSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new LongGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    @Override
    public <T> void register(String name, Supplier<T> supplier, Class<T> type, @Nullable String desc) {
        this.addMetric(name, new ObjectGauge<T>(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log), type));
    }

    public DoubleMetricImpl doubleMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new DoubleMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public IntMetricImpl intMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new IntMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public AtomicLongMetric longMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new AtomicLongMetric(MetricUtils.metricName(this.regName, name), desc));
    }

    public LongAdderMetric longAdderMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new LongAdderMetric(MetricUtils.metricName(this.regName, name), desc));
    }

    public LongAdderWithDelegateMetric longAdderMetric(String name, LongAdderWithDelegateMetric.Delegate delegate, @Nullable String desc) {
        return this.addMetric(name, new LongAdderWithDelegateMetric(MetricUtils.metricName(this.regName, name), delegate, desc));
    }

    public HitRateMetric hitRateMetric(String name, @Nullable String desc, long rateTimeInterval, int size) {
        return this.addMetric(name, new HitRateMetric(MetricUtils.metricName(this.regName, name), desc, rateTimeInterval, size));
    }

    public BooleanMetricImpl booleanMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new BooleanMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public HistogramMetricImpl histogram(String name, long[] bounds, @Nullable String desc) {
        return this.addMetric(name, new HistogramMetricImpl(MetricUtils.metricName(this.regName, name), desc, bounds));
    }

    private <T extends Metric> T addMetric(String name, T metric) throws IgniteException {
        if (metric == null) {
            throw new IllegalArgumentException("Null metric passed with name '" + name + "'.");
        }
        Metric old = this.metrics.putIfAbsent(MetricUtils.metricName(name), metric);
        if (old != null) {
            if (!metric.getClass().isAssignableFrom(old.getClass())) {
                throw new IgniteException("Other metric with name '" + name + "' is already registered.");
            }
            return (T)old;
        }
        if (!MetricUtils.customMetric(this.name())) {
            this.configureMetrics(metric);
        }
        return metric;
    }

    private void configureMetrics(Metric metric) {
        Long cfgRateTimeInterval;
        assert (!MetricUtils.customMetric(this.name())) : "Custom metrics cannot be configured yet";
        if (metric instanceof HistogramMetricImpl) {
            long[] cfgBounds = this.histogramCfgProvider.apply(metric.name());
            if (cfgBounds != null) {
                ((HistogramMetricImpl)metric).reset(cfgBounds);
            }
        } else if (metric instanceof HitRateMetric && (cfgRateTimeInterval = this.hitRateCfgProvider.apply(metric.name())) != null) {
            ((HitRateMetric)metric).reset(cfgRateTimeInterval, 10);
        }
    }

    @Override
    public String name() {
        return this.regName;
    }
}

