/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster.baseline.autoadjust;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustData;

class BaselineAutoAdjustExecutor {
    private final IgniteLogger log;
    private final IgniteClusterImpl cluster;
    private final ExecutorService executorService;
    private final BooleanSupplier isBaselineAutoAdjustEnabled;
    private final Lock executionGuard = new ReentrantLock();

    public BaselineAutoAdjustExecutor(IgniteLogger log, IgniteClusterImpl cluster, ExecutorService executorService, BooleanSupplier enabledSupplier) {
        this.log = log;
        this.cluster = cluster;
        this.executorService = executorService;
        this.isBaselineAutoAdjustEnabled = enabledSupplier;
    }

    public void execute(BaselineAutoAdjustData data) {
        this.executorService.submit(() -> {
            if (this.isExecutionExpired(data)) {
                return;
            }
            this.executionGuard.lock();
            try {
                if (this.isExecutionExpired(data)) {
                    return;
                }
                this.cluster.triggerBaselineAutoAdjust(data.getTargetTopologyVersion());
            }
            catch (IgniteException e) {
                this.log.error("Error during baseline changing", e);
            }
            finally {
                data.onAdjust();
                this.executionGuard.unlock();
            }
        });
    }

    public boolean isExecutionExpired(BaselineAutoAdjustData data) {
        return data.isInvalidated() || !this.isBaselineAutoAdjustEnabled.getAsBoolean();
    }
}

