/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.ignite3.configuration.ConfigurationValue;
import org.apache.ignite3.configuration.NamedConfigurationTree;
import org.apache.ignite3.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite3.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite3.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite3.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite3.internal.configuration.direct.DirectConfigurationProxy;
import org.apache.ignite3.internal.configuration.direct.DirectNamedListProxy;
import org.apache.ignite3.internal.configuration.direct.DirectValueProxy;
import org.apache.ignite3.internal.configuration.direct.KeyPathNode;
import org.apache.ignite3.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

class DirectProxyAsmGenerator
extends AbstractAsmGenerator {
    private static final Constructor<?> DIRECT_CFG_CTOR;
    private static final Method APPEND_KEY;
    private ClassDefinition classDef;

    DirectProxyAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> extensions, List<Field> schemaFields, Collection<Field> publicExtensionFields, Collection<Field> internalExtensionFields, @Nullable Field internalIdField) {
        super(cgen, schemaClass, extensions, null, schemaFields, publicExtensionFields, internalExtensionFields, null, internalIdField);
    }

    @Override
    public List<ClassDefinition> generate() {
        assert (this.classDef == null);
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.directProxyClassName), ParameterizedType.type(DirectConfigurationProxy.class), this.cgen.configClassInterfaces(this.schemaClass, this.extensions));
        this.addConstructor();
        this.addDirectProxyMethod();
        if (this.internalIdField != null) {
            this.addGetMethod(this.internalIdField);
        }
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            this.addGetMethod(schemaField);
        }
        return List.of(this.classDef);
    }

    private void addConstructor() {
        MethodDefinition ctor = this.classDef.declareConstructor(EnumSet.of(Access.PUBLIC), Parameter.arg("keys", List.class), Parameter.arg("changer", DynamicConfigurationChanger.class));
        ctor.getBody().append(ctor.getThis()).append(ctor.getScope().getVariable("keys")).append(ctor.getScope().getVariable("changer")).invokeConstructor(DIRECT_CFG_CTOR).ret();
    }

    private void addDirectProxyMethod() {
        MethodDefinition directProxy = this.classDef.declareMethod(EnumSet.of(Access.PUBLIC), "directProxy", ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(this.schemaClass).cfgClassName), new Parameter[0]);
        directProxy.getBody().append(directProxy.getThis()).retObject();
    }

    private void addGetMethod(Field schemaField) {
        ParameterizedType returnType;
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) : schemaField;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition methodDef = this.classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock body = methodDef.getBody();
        if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) {
            body.append(BytecodeExpressions.newInstance(DirectValueProxy.class, BytecodeExpressions.invokeStatic(APPEND_KEY, methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, BytecodeExpressions.constantString(ConfigurationUtil.isInjectedName(schemaField) ? "<injected_name>" : (ConfigurationUtil.isInternalId(schemaField) ? "<internal_id>" : fieldName)))), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)));
        } else {
            SchemaClassesInfo fieldSchemaClassInfo = this.cgen.schemaInfo(schemaField.getType());
            ParameterizedType resultType = ParameterizedType.typeFromJavaClassName(fieldSchemaClassInfo.directProxyClassName);
            if (ConfigurationUtil.isConfigValue(schemaField)) {
                body.append(BytecodeExpressions.newInstance(resultType, BytecodeExpressions.invokeStatic(APPEND_KEY, methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, BytecodeExpressions.constantString(fieldName))), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)));
            } else {
                body.append(BytecodeExpressions.newInstance(DirectNamedListProxy.class, BytecodeExpressions.invokeStatic(APPEND_KEY, methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, BytecodeExpressions.constantString(fieldName))), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class), DirectProxyAsmGenerator.newDirectProxyLambda(fieldSchemaClassInfo)));
            }
        }
        body.retObject();
    }

    public static BytecodeExpression newDirectProxyLambda(SchemaClassesInfo schemaClassInfo) {
        return BytecodeExpressions.invokeDynamic(LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), new Handle(8, ConfigurationAsmGenerator.internalName(schemaClassInfo.directProxyClassName), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(List.class), Type.getType(DynamicConfigurationChanger.class)}), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName(schemaClassInfo.directProxyClassName).getAsmType(), (Type[])new Type[]{Type.getType(List.class), Type.getType(DynamicConfigurationChanger.class)})), "apply", MethodType.methodType(BiFunction.class), new BytecodeExpression[0]);
    }

    static {
        try {
            DIRECT_CFG_CTOR = DirectConfigurationProxy.class.getDeclaredConstructor(List.class, DynamicConfigurationChanger.class);
            APPEND_KEY = ConfigurationUtil.class.getDeclaredMethod("appendKey", List.class, Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

