/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat;

import java.util.Collection;
import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CancelButton;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.GeneralSettingsComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.IDialogComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.OkButton;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.PopulateInputsAdapter;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.TransformNameComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AnthropicComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.HuggingFaceComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.IModelComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.MistralComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.OllamaComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.OpenAiComposite;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LanguageModelChatDialog
extends BaseTransformDialog
implements ITransformDialog,
PopulateInputsAdapter {
    private final LanguageModelChatMeta input;
    private Collection<IDialogComposite> composites;

    public LanguageModelChatDialog(Shell parent, IVariables variables, LanguageModelChatMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        int margin = PropsUi.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(i18nUtil.i18n("LanguageModelChatDialog.Shell.Title"));
        final Composite modelComposite = new Composite((Composite)this.shell, 2048);
        PopulateInputsAdapter modelCompositeInputsAdapter = new PopulateInputsAdapter(){

            @Override
            public void populateInputs() {
                LanguageModelChatDialog.this.populateInputs(modelComposite);
            }
        };
        CompositeParameters.Builder params = CompositeParameters.Builder.buildCompositeParameters().dialog(this).populateInputsAdapter(modelCompositeInputsAdapter).middlePct(this.props.getMiddlePct()).margin(margin).shell(this.shell).parent((Composite)this.shell).meta((ITransformMeta)this.input).variables(this.variables).transformName(this.transformName).pipelineMeta(this.pipelineMeta);
        TransformNameComposite tnc = new TransformNameComposite(params.build());
        GeneralSettingsComposite gsc = new GeneralSettingsComposite(params.control((Control)this.shell).build());
        modelComposite.setLayout((Layout)new FormLayout());
        FormData fdModelSpecificComp = new FormData();
        fdModelSpecificComp.left = new FormAttachment(0, 0);
        fdModelSpecificComp.top = new FormAttachment(gsc.control(), margin);
        fdModelSpecificComp.right = new FormAttachment(100, 0);
        fdModelSpecificComp.bottom = new FormAttachment(100, -50);
        modelComposite.setLayoutData((Object)fdModelSpecificComp);
        PropsUi.setLook((Widget)modelComposite);
        params.parent(modelComposite);
        AnthropicComposite anthropic = new AnthropicComposite(params.control((Control)modelComposite).build());
        HuggingFaceComposite huggingface = new HuggingFaceComposite(params.control((Control)modelComposite).build());
        MistralComposite mistral = new MistralComposite(params.control((Control)modelComposite).build());
        OllamaComposite ollama = new OllamaComposite(params.control((Control)modelComposite).build());
        OpenAiComposite openai = new OpenAiComposite(params.control((Control)modelComposite).build());
        this.composites = List.of(tnc, gsc, anthropic, huggingface, mistral, ollama, openai);
        this.setButtonPositions(new Button[]{new OkButton((Composite)this.shell, e -> this.ok()).delegate(), new CancelButton((Composite)this.shell, e -> this.cancel()).delegate()}, margin, (Control)modelComposite);
        this.populateInputs(modelComposite);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    @Override
    public void populateInputs(Composite composite) {
        for (IDialogComposite c : this.composites) {
            if (!(c instanceof IModelComposite)) continue;
            c.composite().setVisible(false);
            c.updateLayouts();
        }
        this.composites.forEach(PopulateInputsAdapter::populateInputs);
        for (IDialogComposite c : this.composites) {
            IModelComposite m;
            if (c instanceof IModelComposite && (m = (IModelComposite)c).isSelectedModelType()) {
                c.composite().setVisible(true);
                c.updateLayouts();
            }
            c.updateLayouts();
        }
        composite.layout(true, true);
        this.shell.layout(true, true);
        this.input.setChanged(this.changed);
    }

    private void ok() {
        int validated = (int)this.composites.stream().filter(IDialogComposite::validateInputs).count();
        if (validated != this.composites.size()) {
            return;
        }
        if (this.composites.stream().anyMatch(c -> !c.ok())) {
            return;
        }
        this.input.setChanged();
        this.dispose();
    }

    private void cancel() {
        this.composites.forEach(IDialogComposite::cancel);
        this.transformName = null;
        this.input.setChanged(false);
        this.dispose();
    }
}

