/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.query;

import io.github.spannm.jackcess.impl.query.QueryFormat;
import io.github.spannm.jackcess.impl.query.QueryImpl;
import io.github.spannm.jackcess.query.BaseSelectQuery;
import io.github.spannm.jackcess.query.Query;
import java.util.List;

public abstract class BaseSelectQueryImpl
extends QueryImpl
implements BaseSelectQuery {
    protected BaseSelectQueryImpl(String name, List<QueryImpl.Row> rows, int objectId, int objectFlag, Query.Type type) {
        super(name, rows, objectId, objectFlag, type);
    }

    protected void toSQLSelectString(StringBuilder builder, boolean useSelectPrefix) {
        List<String> orderings;
        String havingExpr;
        List<String> groupings;
        String whereExpr;
        if (useSelectPrefix) {
            builder.append("SELECT ");
            String selectType = this.getSelectType();
            if (!"".equals(selectType)) {
                builder.append(selectType).append(' ');
            }
        }
        builder.append(this.getSelectColumns());
        this.toSelectInto(builder);
        List<String> fromTables = this.getFromTables();
        if (!fromTables.isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("FROM ").append(fromTables);
            BaseSelectQueryImpl.toRemoteDb(builder, this.getFromRemoteDbPath(), this.getFromRemoteDbType());
        }
        if ((whereExpr = this.getWhereExpression()) != null) {
            builder.append(QueryFormat.NEWLINE).append("WHERE ").append(whereExpr);
        }
        if (!(groupings = this.getGroupings()).isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("GROUP BY ").append(groupings);
        }
        if ((havingExpr = this.getHavingExpression()) != null) {
            builder.append(QueryFormat.NEWLINE).append("HAVING ").append(havingExpr);
        }
        if (!(orderings = this.getOrderings()).isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("ORDER BY ").append(orderings);
        }
    }

    @Override
    public String getSelectType() {
        if (this.hasFlag(2)) {
            return "DISTINCT";
        }
        if (this.hasFlag(8)) {
            return "DISTINCTROW";
        }
        if (this.hasFlag(16)) {
            StringBuilder builder = new StringBuilder("TOP ").append(this.getFlagRow()._name1);
            if (this.hasFlag(32)) {
                builder.append(" PERCENT");
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public List<String> getSelectColumns() {
        List<String> result = new QueryImpl.RowFormatter(this.getColumnRows()){

            @Override
            protected void format(StringBuilder builder, QueryImpl.Row row) {
                builder.append(row._expression);
                QueryImpl.toAlias(builder, row._name1);
            }
        }.format();
        if (this.hasFlag(1)) {
            result.add("*");
        }
        return result;
    }

    protected void toSelectInto(StringBuilder builder) {
    }

    @Override
    public List<String> getFromTables() {
        return super.getFromTables();
    }

    @Override
    public String getFromRemoteDbPath() {
        return super.getFromRemoteDbPath();
    }

    @Override
    public String getFromRemoteDbType() {
        return super.getFromRemoteDbType();
    }

    @Override
    public String getWhereExpression() {
        return super.getWhereExpression();
    }

    @Override
    public List<String> getGroupings() {
        return new QueryImpl.RowFormatter(this.getGroupByRows()){

            @Override
            protected void format(StringBuilder builder, QueryImpl.Row row) {
                builder.append(row._expression);
            }
        }.format();
    }

    @Override
    public String getHavingExpression() {
        return this.getHavingRow()._expression;
    }

    @Override
    public List<String> getOrderings() {
        return super.getOrderings();
    }
}

