/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.partition;

import java.util.Collections;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.ui.core.metadata.MetadataManager;

public class PartitionSettings {
    private final TransformMeta transformMeta;
    private final PipelineMeta pipelineMeta;
    private final MetadataManager<PartitionSchema> schemaManager;
    private final String[] options;
    private final String[] codes;
    private final TransformMeta before;

    public PartitionSettings(int exactSize, PipelineMeta pipelineMeta, TransformMeta transformMeta, MetadataManager<PartitionSchema> schemaManager) {
        this.pipelineMeta = pipelineMeta;
        this.transformMeta = transformMeta;
        this.schemaManager = schemaManager;
        this.options = new String[exactSize];
        this.codes = new String[exactSize];
        this.before = (TransformMeta)transformMeta.clone();
        System.arraycopy(TransformPartitioningMeta.methodDescriptions, 0, this.options, 0, TransformPartitioningMeta.methodDescriptions.length);
        System.arraycopy(TransformPartitioningMeta.methodCodes, 0, this.codes, 0, TransformPartitioningMeta.methodCodes.length);
    }

    public void fillOptionsAndCodesByPlugins(List<IPlugin> plugins) {
        int pluginIndex = 0;
        for (IPlugin plugin : plugins) {
            this.options[TransformPartitioningMeta.methodDescriptions.length + pluginIndex] = plugin.getDescription();
            this.codes[TransformPartitioningMeta.methodCodes.length + pluginIndex] = plugin.getIds()[0];
            ++pluginIndex;
        }
    }

    public int getDefaultSelectedMethodIndex() {
        for (int i = 0; i < this.codes.length; ++i) {
            if (!this.codes[i].equals(this.transformMeta.getTransformPartitioningMeta().getMethod())) continue;
            return i;
        }
        return 0;
    }

    public int getDefaultSelectedSchemaIndex() {
        List<String> schemaNames;
        try {
            schemaNames = this.schemaManager.getNames();
        }
        catch (HopException e) {
            schemaNames = Collections.emptyList();
        }
        PartitionSchema partitioningSchema = this.transformMeta.getTransformPartitioningMeta().getPartitionSchema();
        int defaultSelectedSchemaIndex = 0;
        if (partitioningSchema != null && partitioningSchema.getName() != null && !schemaNames.isEmpty()) {
            defaultSelectedSchemaIndex = Const.indexOfString((String)partitioningSchema.getName(), schemaNames);
        }
        return defaultSelectedSchemaIndex != -1 ? defaultSelectedSchemaIndex : 0;
    }

    public String getMethodByMethodDescription(String methodDescription) {
        String method = TransformPartitioningMeta.methodCodes[0];
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(methodDescription)) continue;
            method = this.codes[i];
        }
        return method;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public List<String> getSchemaNames() {
        try {
            return this.schemaManager.getNames();
        }
        catch (HopException e) {
            return Collections.emptyList();
        }
    }

    public String[] getSchemaNamesArray() {
        List<String> schemas = this.getSchemaNames();
        return schemas.toArray(new String[schemas.size()]);
    }

    public List<PartitionSchema> getSchemas() {
        try {
            return this.schemaManager.getSerializer().loadAll();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return Collections.emptyList();
        }
    }

    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    public void updateMethodType(int methodType) {
        this.transformMeta.getTransformPartitioningMeta().setMethodType(methodType);
    }

    public void updateMethod(String method) throws HopPluginException {
        this.transformMeta.getTransformPartitioningMeta().setMethod(method);
    }

    public void updateSchema(PartitionSchema schema) {
        if (schema != null && schema.getName() != null) {
            this.transformMeta.getTransformPartitioningMeta().setPartitionSchema(schema);
        }
    }

    public void rollback(TransformMeta before) throws HopPluginException {
        this.updateMethod(before.getTransformPartitioningMeta().getMethod());
        this.updateMethodType(before.getTransformPartitioningMeta().getMethodType());
        this.updateSchema(before.getTransformPartitioningMeta().getPartitionSchema());
    }

    public TransformMeta getBefore() {
        return this.before;
    }

    public TransformMeta getAfter() {
        return (TransformMeta)this.transformMeta.clone();
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }
}

