/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

public class PowershellManager {
    private static final ClientLogger LOGGER = new ClientLogger(PowershellManager.class);
    private static final String DEFAULT_WINDOWS_POWERSHELL_PATH = "pwsh.exe";
    private static final String LEGACY_WINDOWS_POWERSHELL_PATH = "powershell.exe";
    private static final String DEFAULT_NIX_POWERSHELL_PATH = "pwsh";
    private final String powershellPath;

    public PowershellManager(boolean useLegacyPowerShell) {
        this.powershellPath = Platform.isWindows() ? (useLegacyPowerShell ? LEGACY_WINDOWS_POWERSHELL_PATH : DEFAULT_WINDOWS_POWERSHELL_PATH) : DEFAULT_NIX_POWERSHELL_PATH;
    }

    public Mono<String> runCommand(String input) {
        return Mono.fromCallable(() -> {
            try {
                String[] command = this.getCommandLine(input);
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                process.waitFor(10000L, TimeUnit.MILLISECONDS);
                StringBuilder output = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append(System.lineSeparator());
                    }
                }
                return output.toString();
            }
            catch (IOException | InterruptedException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("PowerShell command failure.", e)));
            }
        });
    }

    String[] getCommandLine(String input) {
        String[] stringArray;
        if (Platform.isWindows()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = this.powershellPath;
            stringArray2[1] = "-Command";
            stringArray2[2] = "-NoProfile";
            stringArray = stringArray2;
            stringArray2[3] = input;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "/bin/bash";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = String.format("%s -NoProfile -Command '%s'", this.powershellPath, input);
        }
        return stringArray;
    }
}

