/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.documentation;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.documentation.DocBuilder;
import org.apache.hop.documentation.DocDelegate;
import org.apache.hop.documentation.Toc;
import org.apache.hop.documentation.TocEntry;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowSvgPainter;

public class WorkflowDocDelegate
extends DocDelegate {
    private final ILogChannel log;

    public WorkflowDocDelegate(DocBuilder builder) {
        super(builder);
        this.log = builder.getLog();
    }

    public void buildWorkflowDocumentation(Toc toc, FileObject targetRootFolder, FileObject sourceFolder, FileObject targetFolder, String relativeName, FileObject file) throws Exception {
        String targetFileName = this.calculateTargetDocumentationFile(targetFolder, file);
        String relativeSourceFile = sourceFolder.getName().getRelativeName(file.getName());
        this.log.logBasic(" - documenting workflow: " + relativeSourceFile + " to " + targetFileName);
        WorkflowMeta workflowMeta = new WorkflowMeta(this.builder.getVariables(), file.getName().getPath(), (IHopMetadataProvider)this.builder.getMetadataProvider());
        String workflowName = workflowMeta.getName();
        StringBuilder content = new StringBuilder();
        content.append("---").append(Const.CR).append("title: Workflow ").append(workflowName).append(Const.CR).append("---").append(Const.CR).append(Const.CR);
        this.addDetails((AbstractMeta)workflowMeta, content, relativeSourceFile);
        String workflowSvg = WorkflowSvgPainter.generateWorkflowSvg((WorkflowMeta)workflowMeta, (float)1.0f, (IVariables)this.builder.getVariables());
        String relativeSvgFilename = this.calculateTargetImageFile(workflowName, "workflow");
        String svgFilename = targetRootFolder.getName().getPath() + "/assets/images/" + relativeSvgFilename;
        this.builder.saveFile(svgFilename, workflowSvg);
        String relativeSvgPath = HopVfs.getFileObject((String)targetFileName).getParent().getName().getRelativeName(HopVfs.getFileObject((String)svgFilename).getName());
        content.append("## Image ").append(Const.CR).append(Const.CR).append("![*Image of workflow : ").append(workflowName).append("*]").append("(").append(relativeSvgPath).append(" \"").append("Workflow ").append(workflowName).append("\"").append(")").append(Const.CR).append(Const.CR);
        if (this.builder.isIncludingNotes() && !workflowMeta.getNotes().isEmpty()) {
            content.append("## Notes : ").append(Const.CR).append(Const.CR);
            ArrayList<NotePadMeta> notes = new ArrayList<NotePadMeta>(workflowMeta.getNotes());
            notes.sort(Comparator.comparing(NotePadMeta::getNote));
            for (NotePadMeta note : notes) {
                content.append(note.getNote()).append(Const.CR);
            }
            content.append(Const.CR);
        }
        this.builder.saveFile(targetFileName, content.toString());
        String relativeTargetFilename = targetRootFolder.getName().getRelativeName(HopVfs.getFileObject((String)targetFileName).getName());
        toc.getEntries().add(new TocEntry(relativeName, "Workflow", workflowName, relativeSourceFile, relativeTargetFilename));
    }
}

