/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;

public final class NLS {
    private static final String CLASSNAME = "com.ibm.as400.access.NLS";
    private static int countryBytes_;
    private static int languageBytes_;
    private static final Hashtable languages_;
    private static final Hashtable countries_;
    static boolean forceJavaTables_;

    private NLS() {
    }

    public static String ccsidToEncoding(int ccsid) {
        return (String)ConversionMaps.ccsidEncoding_.get(Integer.toString(ccsid));
    }

    public static int encodingToCCSID(String encoding) {
        if (encoding == null) {
            return -1;
        }
        String ccsid = (String)ConversionMaps.encodingCcsid_.get(encoding);
        if (ccsid == null) {
            return -1;
        }
        return Integer.parseInt(ccsid);
    }

    public static int localeToCCSID(String localeString) {
        if (localeString == null) {
            return -1;
        }
        for (String ls = localeString.trim(); ls != null && ls.length() > 0; ls = ls.substring(0, ls.lastIndexOf(95))) {
            String ccsidString = (String)ConversionMaps.localeCcsidMap_.get(ls);
            if (ccsidString == null) continue;
            return Integer.parseInt(ccsidString);
        }
        return -1;
    }

    public static int localeToCCSID(Locale locale) {
        if (locale == null) {
            return -1;
        }
        String ls = locale.toString();
        return NLS.localeToCCSID(ls);
    }

    public static String localeToNLV(String localeString) {
        if (localeString == null) {
            return "";
        }
        for (String ls = localeString.trim(); ls != null && ls.length() > 0; ls = ls.substring(0, ls.lastIndexOf(95))) {
            String nlvString = (String)ConversionMaps.localeNlvMap_.get(ls);
            if (nlvString == null) continue;
            return nlvString;
        }
        return "";
    }

    public static String localeToNLV(Locale locale) {
        if (locale == null) {
            return "";
        }
        String ls = locale.toString();
        return NLS.localeToNLV(ls);
    }

    public static String getCountryDescription(AS400 system, String countryID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String description = (String)countries_.get(countryID = countryID.trim().toUpperCase());
        if (description == null) {
            int ccsid = system.getCcsid();
            ConvTable conv = ConvTable.getTable(ccsid, null);
            ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(countryBytes_), new ProgramParameter(BinaryConverter.intToByteArray(countryBytes_)), new ProgramParameter(conv.stringToByteArray("RTVC0100")), new ProgramParameter(new byte[4])};
            ProgramCall pc = new ProgramCall(system, "/QSYS.LIB/QLGRTVCI.PGM", parms);
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            byte[] output = parms[0].getOutputData();
            int bytesReturned = BinaryConverter.byteArrayToInt(output, 0);
            int bytesAvailable = BinaryConverter.byteArrayToInt(output, 4);
            int offset = BinaryConverter.byteArrayToInt(output, 12);
            if (bytesAvailable > bytesReturned) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Increasing RetrieveCountryID chunk size from " + countryBytes_ + " to " + (bytesAvailable + offset) + " and re-retrieving.");
                }
                countryBytes_ = bytesAvailable + offset;
                return NLS.getCountryDescription(system, countryID);
            }
            ccsid = BinaryConverter.byteArrayToInt(output, 8);
            conv = ConvTable.getTable(ccsid, null);
            int numberOfIDs = BinaryConverter.byteArrayToInt(output, 16);
            for (int i = 0; i < numberOfIDs; ++i) {
                String country = conv.byteArrayToString(output, offset, 2).trim().toUpperCase();
                String descriptiveText = conv.byteArrayToString(output, offset += 2, 40).trim();
                offset += 40;
                countries_.put(country, descriptiveText);
                if (!country.equals(countryID)) continue;
                description = descriptiveText;
            }
        }
        return description;
    }

    public static String getLanguageDescription(AS400 system, String languageID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String description = (String)languages_.get(languageID = languageID.trim().toUpperCase());
        if (description == null) {
            int ccsid = system.getCcsid();
            ConvTable conv = ConvTable.getTable(ccsid, null);
            ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(languageBytes_), new ProgramParameter(BinaryConverter.intToByteArray(languageBytes_)), new ProgramParameter(conv.stringToByteArray("RTVL0100")), new ProgramParameter(new byte[4])};
            ProgramCall pc = new ProgramCall(system, "/QSYS.LIB/QLGRTVLI.PGM", parms);
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            byte[] output = parms[0].getOutputData();
            int bytesAvailable = BinaryConverter.byteArrayToInt(output, 0);
            int bytesReturned = BinaryConverter.byteArrayToInt(output, 4);
            int offset = BinaryConverter.byteArrayToInt(output, 16);
            if (bytesAvailable > bytesReturned) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Increasing RetrieveLanguageID chunk size from " + languageBytes_ + " to " + (bytesAvailable + offset) + " and re-retrieving.");
                }
                languageBytes_ = bytesAvailable + offset;
                return NLS.getLanguageDescription(system, languageID);
            }
            int numberOfIDs = BinaryConverter.byteArrayToInt(output, 8);
            ccsid = BinaryConverter.byteArrayToInt(output, 12);
            conv = ConvTable.getTable(ccsid, null);
            for (int i = 0; i < numberOfIDs; ++i) {
                String lang = conv.byteArrayToString(output, offset, 3).trim().toUpperCase();
                String descriptiveText = conv.byteArrayToString(output, offset += 3, 40).trim();
                offset += 40;
                languages_.put(lang, descriptiveText);
                if (!lang.equals(languageID)) continue;
                description = descriptiveText;
            }
        }
        return description;
    }

    public static boolean isForceJavaConversion() {
        return forceJavaTables_;
    }

    public static void setForceJavaConversion(boolean forceJavaTables) {
        forceJavaTables_ = forceJavaTables;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        countryBytes_ = 11000;
        languageBytes_ = 3000;
        languages_ = new Hashtable();
        countries_ = new Hashtable();
        forceJavaTables_ = false;
    }
}

