/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;
import org.owasp.encoder.Encode;

@HopServerServlet(id="stopWorkflow", name="Stop a workflow")
public class StopWorkflowServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = StopWorkflowServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/stopWorkflow";

    public StopWorkflowServlet() {
    }

    public StopWorkflowServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StopWorkflowServlet.log.StopWorkflowRequested", (String[])new String[0]));
        }
        String workflowName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        try {
            IWorkflowEngine<WorkflowMeta> workflow;
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Stop workflow</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/workflowStatus") + "?name=" + URLEncoder.encode(workflowName, StandardCharsets.UTF_8) + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            if (Utils.isEmpty((CharSequence)id)) {
                HopServerObjectEntry entry = this.getWorkflowMap().getFirstHopServerObjectEntry(workflowName);
                if (entry == null) {
                    workflow = null;
                } else {
                    id = entry.getId();
                    workflow = this.getWorkflowMap().getWorkflow(entry);
                }
            } else {
                HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, id);
                workflow = this.getWorkflowMap().getWorkflow(entry);
            }
            if (workflow != null) {
                workflow.stopExecution();
                String message = BaseMessages.getString(PKG, (String)"WorkflowStatusServlet.Log.WorkflowStopRequested", (String[])new String[]{workflowName});
                if (useXML) {
                    out.println(new WebResult("OK", message).getXml());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/workflowStatus") + "?name=" + URLEncoder.encode(workflowName, StandardCharsets.UTF_8) + "&id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + "\">" + BaseMessages.getString(PKG, (String)"WorkflowStatusServlet.BackToWorkflowStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"StopWorkflowServlet.Log.CoundNotFindWorkflow", (String[])new String[]{workflowName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message).getXml());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/status") + ">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXml());
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
            response.setStatus(400);
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Stop workflow";
    }

    @Override
    public String getService() {
        return "/hop/stopWorkflow (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

