/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CommandLineArguments {
    private Vector extraOptions_ = new Vector();
    private Hashtable map_ = new Hashtable();

    public CommandLineArguments(String[] args) {
        this(args, null, new Hashtable());
    }

    public CommandLineArguments(String[] args, Vector expectedOptions, Hashtable shortcuts) {
        if (expectedOptions != null) {
            Vector<String> normalizedExpectedOptions = new Vector<String>();
            Enumeration list = expectedOptions.elements();
            while (list.hasMoreElements()) {
                normalizedExpectedOptions.addElement(list.nextElement().toString().toLowerCase());
            }
            expectedOptions = normalizedExpectedOptions;
        }
        String currentOptionName = "-";
        StringBuffer currentOptionValue = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOptionName(arg)) {
                this.map_.put(currentOptionName, currentOptionValue);
                currentOptionName = arg.toLowerCase();
                if (shortcuts != null && shortcuts.containsKey(currentOptionName)) {
                    currentOptionName = ((String)shortcuts.get(currentOptionName)).toLowerCase();
                }
                if (expectedOptions != null && !expectedOptions.contains(currentOptionName)) {
                    this.extraOptions_.addElement(currentOptionName);
                }
                if (this.map_.containsKey(currentOptionName)) {
                    currentOptionValue = (StringBuffer)this.map_.get(currentOptionName);
                    continue;
                }
                currentOptionValue = new StringBuffer();
                continue;
            }
            currentOptionValue.append(" ");
            currentOptionValue.append(arg);
        }
        this.map_.put(currentOptionName, currentOptionValue);
    }

    public Enumeration getExtraOptions() {
        return this.extraOptions_.elements();
    }

    public Enumeration getOptionNames() {
        return this.map_.keys();
    }

    public String getOptionValue(String optionName) {
        String key = !optionName.startsWith("-") ? "-" + optionName.toLowerCase() : optionName.toLowerCase();
        if (this.map_.containsKey(key)) {
            return this.map_.get(key).toString().trim();
        }
        return null;
    }

    public boolean isOptionSpecified(String optionName) {
        return this.getOptionValue(optionName) != null;
    }

    private boolean isOptionName(String arg) {
        if (!arg.startsWith("-")) {
            return false;
        }
        try {
            Double.valueOf(arg.substring(1));
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

