/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ADPOSSampleStream
implements ObjectStream<POSSample> {
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private boolean expandME;
    private boolean isIncludeFeatures;

    public ADPOSSampleStream(ObjectStream<String> lineStream, boolean expandME, boolean includeFeatures) {
        this.adSentenceStream = new ADSentenceStream(lineStream);
        this.expandME = expandME;
        this.isIncludeFeatures = includeFeatures;
    }

    public ADPOSSampleStream(InputStreamFactory in, String charsetName, boolean expandME, boolean includeFeatures) throws IOException {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
            this.expandME = expandME;
            this.isIncludeFeatures = includeFeatures;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public POSSample read() throws IOException {
        ADSentenceStream.Sentence paragraph = this.adSentenceStream.read();
        if (paragraph != null) {
            ADSentenceStream.SentenceParser.Node root = paragraph.getRoot();
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            this.process(root, sentence, tags);
            return new POSSample(sentence, tags);
        }
        return null;
    }

    private void process(ADSentenceStream.SentenceParser.Node node, List<String> sentence, List<String> tags) {
        if (node != null) {
            for (ADSentenceStream.SentenceParser.TreeElement element : node.getElements()) {
                if (element.isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)element, sentence, tags);
                    continue;
                }
                this.process((ADSentenceStream.SentenceParser.Node)element, sentence, tags);
            }
        }
    }

    private void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, List<String> sentence, List<String> tags) {
        if (leaf != null) {
            String lexeme = leaf.getLexeme();
            String tag = leaf.getFunctionalTag();
            if (tag == null) {
                tag = leaf.getLexeme();
            }
            if (this.isIncludeFeatures && leaf.getMorphologicalTag() != null) {
                tag = tag + " " + leaf.getMorphologicalTag();
            }
            if ((tag = tag.replaceAll("\\s+", "=")) == null) {
                tag = lexeme;
            }
            if (this.expandME && lexeme.contains("_")) {
                StringTokenizer tokenizer = new StringTokenizer(lexeme, "_");
                if (tokenizer.countTokens() > 0) {
                    ArrayList<String> toks = new ArrayList<String>(tokenizer.countTokens());
                    ArrayList<String> tagsWithCont = new ArrayList<String>(tokenizer.countTokens());
                    toks.add(tokenizer.nextToken());
                    tagsWithCont.add("B-" + tag);
                    while (tokenizer.hasMoreTokens()) {
                        toks.add(tokenizer.nextToken());
                        tagsWithCont.add("I-" + tag);
                    }
                    sentence.addAll(toks);
                    tags.addAll(tagsWithCont);
                } else {
                    sentence.add(lexeme);
                    tags.add(tag);
                }
            } else {
                sentence.add(lexeme);
                tags.add(tag);
            }
        }
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }
}

