/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileexists;

import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fileexists.FileExistsData;
import org.apache.hop.pipeline.transforms.fileexists.FileExistsMeta;

public class FileExists
extends BaseTransform<FileExistsMeta, FileExistsData> {
    private static final Class<?> PKG = FileExistsMeta.class;

    public FileExists(TransformMeta transformMeta, FileExistsMeta meta, FileExistsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block15: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean fileexists = false;
            String filetype = null;
            try {
                if (this.first) {
                    this.first = false;
                    ((FileExistsData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                    ((FileExistsData)this.data).NrPrevFields = ((FileExistsData)this.data).previousRowMeta.size();
                    ((FileExistsData)this.data).outputRowMeta = ((FileExistsData)this.data).previousRowMeta;
                    ((FileExistsMeta)this.meta).getFields(((FileExistsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    if (Utils.isEmpty((CharSequence)((FileExistsMeta)this.meta).getFilenamefield())) {
                        this.logError(BaseMessages.getString(PKG, (String)"FileExists.Error.FilenameFieldMissing", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"FileExists.Error.FilenameFieldMissing", (String[])new String[0]));
                    }
                    if (((FileExistsData)this.data).indexOfFileename < 0) {
                        ((FileExistsData)this.data).indexOfFileename = ((FileExistsData)this.data).previousRowMeta.indexOfValue(((FileExistsMeta)this.meta).getFilenamefield());
                        if (((FileExistsData)this.data).indexOfFileename < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"FileExists.Exception.CouldnotFindField", (String[])new String[0]) + "[" + ((FileExistsMeta)this.meta).getFilenamefield() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"FileExists.Exception.CouldnotFindField", (String[])new String[]{((FileExistsMeta)this.meta).getFilenamefield()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)((FileExistsData)this.data).outputRowMeta.size());
                for (int i = 0; i < ((FileExistsData)this.data).NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                String filename = ((FileExistsData)this.data).previousRowMeta.getString(r, ((FileExistsData)this.data).indexOfFileename);
                if (!Utils.isEmpty((CharSequence)filename)) {
                    ((FileExistsData)this.data).file = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
                    fileexists = ((FileExistsData)this.data).file.exists();
                    if (((FileExistsMeta)this.meta).isIncludefiletype() && fileexists && !Utils.isEmpty((CharSequence)((FileExistsMeta)this.meta).getFiletypefieldname())) {
                        filetype = ((FileExistsData)this.data).file.getType().toString();
                    }
                    if (((FileExistsMeta)this.meta).isAddresultfilenames() && fileexists && ((FileExistsData)this.data).file.getType() == FileType.FILE) {
                        ResultFile resultFile = new ResultFile(0, ((FileExistsData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"FileExists.Log.FileAddedResult", (String[])new String[0]));
                        this.addResultFile(resultFile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"FileExists.Log.FilenameAddResult", (String[])new String[]{((FileExistsData)this.data).file.toString()}));
                        }
                    }
                }
                outputRow[((FileExistsData)this.data).NrPrevFields] = fileexists;
                int rowIndex = ((FileExistsData)this.data).NrPrevFields;
                ++rowIndex;
                if (((FileExistsMeta)this.meta).isIncludefiletype() && !Utils.isEmpty((CharSequence)((FileExistsMeta)this.meta).getFiletypefieldname())) {
                    outputRow[rowIndex] = filetype;
                }
                this.putRow(((FileExistsData)this.data).outputRowMeta, outputRow);
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileExists.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block15;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((FileExistsMeta)this.meta).getResultfieldname(), "FileExistsO01");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((FileExistsMeta)this.meta).getResultfieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"FileExists.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((FileExistsData)this.data).file != null) {
            try {
                ((FileExistsData)this.data).file.close();
                ((FileExistsData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

