/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.jarm;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JARMUtils {
    public static JWTClaimsSet toJWTClaimsSet(Issuer iss, ClientID aud, Date exp, AuthorizationResponse response) {
        if (exp == null) {
            throw new IllegalArgumentException("The expiration time must not be null");
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(iss.getValue()).audience(aud.getValue()).expirationTime(exp);
        for (Map.Entry<String, String> en : MultivaluedMapUtils.toSingleValuedMap(response.toParameters()).entrySet()) {
            if ("response".equals(en.getKey())) continue;
            builder = builder.claim(en.getKey(), (Object)(en.getValue() + ""));
        }
        return builder.build();
    }

    public static Map<String, List<String>> toMultiValuedStringParameters(JWTClaimsSet jwtClaimsSet) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Map.Entry en : jwtClaimsSet.getClaims().entrySet()) {
            params.put((String)en.getKey(), Collections.singletonList(en.getValue() + ""));
        }
        return params;
    }

    public static boolean impliesAuthorizationErrorResponse(String jwtString) throws ParseException {
        try {
            return JARMUtils.impliesAuthorizationErrorResponse(JWTParser.parse((String)jwtString));
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid JWT-secured authorization response: " + e.getMessage(), e);
        }
    }

    public static boolean impliesAuthorizationErrorResponse(JWT jwt) throws ParseException {
        if (jwt instanceof PlainJWT) {
            throw new ParseException("Invalid JWT-secured authorization response: The JWT must not be plain (unsecured)");
        }
        if (jwt instanceof EncryptedJWT) {
            return false;
        }
        if (jwt instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jwt;
            try {
                return signedJWT.getJWTClaimsSet().getStringClaim("error") != null;
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid JWT claims set: " + e.getMessage());
            }
        }
        throw new ParseException("Unexpected JWT type");
    }

    private JARMUtils() {
    }
}

