/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalData;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalMeta;

public class RegexEval
extends BaseTransform<RegexEvalMeta, RegexEvalData> {
    private static final Class<?> PKG = RegexEvalMeta.class;

    public RegexEval(TransformMeta transformMeta, RegexEvalMeta meta, RegexEvalData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block24: {
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((RegexEvalData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                int captureIndex = this.getInputRowMeta().size();
                ((RegexEvalMeta)this.meta).getFields(((RegexEvalData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)this.resolve(((RegexEvalMeta)this.meta).getResultFieldName()))) {
                    if (!((RegexEvalMeta)this.meta).isAllowCaptureGroupsFlagSet()) {
                        this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorResultFieldMissing", (String[])new String[0]));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorResultFieldMissing", (String[])new String[0]));
                    }
                    ((RegexEvalData)this.data).indexOfResultField = -1;
                } else {
                    if (((RegexEvalMeta)this.meta).isReplacefields()) {
                        ((RegexEvalData)this.data).indexOfResultField = this.getInputRowMeta().indexOfValue(((RegexEvalMeta)this.meta).getResultFieldName());
                    }
                    if (((RegexEvalData)this.data).indexOfResultField < 0) {
                        ((RegexEvalData)this.data).indexOfResultField = this.getInputRowMeta().size();
                        ++captureIndex;
                    }
                }
                if (((RegexEvalMeta)this.meta).getMatcher() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorMatcherMissing", (String[])new String[0]));
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorMatcherMissing", (String[])new String[0]));
                }
                ((RegexEvalData)this.data).indexOfFieldToEvaluate = this.getInputRowMeta().indexOfValue(((RegexEvalMeta)this.meta).getMatcher());
                if (((RegexEvalData)this.data).indexOfFieldToEvaluate < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((RegexEvalMeta)this.meta).getMatcher() + "]");
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.CouldnotFindField", (String[])new String[]{((RegexEvalMeta)this.meta).getMatcher()}));
                }
                if (((RegexEvalMeta)this.meta).isAllowCaptureGroupsFlagSet()) {
                    ((RegexEvalData)this.data).positions = new int[((RegexEvalMeta)this.meta).getFieldName().length];
                    String[] fieldName = ((RegexEvalMeta)this.meta).getFieldName();
                    for (int i = 0; i < fieldName.length; ++i) {
                        if (fieldName[i] == null || fieldName[i].length() == 0) continue;
                        ((RegexEvalData)this.data).positions[i] = ((RegexEvalMeta)this.meta).isReplacefields() ? ((RegexEvalData)this.data).outputRowMeta.indexOfValue(fieldName[i]) : captureIndex++;
                    }
                } else {
                    ((RegexEvalData)this.data).positions = new int[0];
                }
                ((RegexEvalData)this.data).conversionRowMeta = ((RegexEvalData)this.data).outputRowMeta.cloneToType(2);
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)((RegexEvalData)this.data).outputRowMeta.size());
            System.arraycopy(row, 0, outputRow, 0, this.getInputRowMeta().size());
            try {
                boolean isMatch;
                if (this.getInputRowMeta().isNull(row, ((RegexEvalData)this.data).indexOfFieldToEvaluate)) {
                    fieldValue = "";
                    isMatch = false;
                } else {
                    fieldValue = this.getInputRowMeta().getString(row, ((RegexEvalData)this.data).indexOfFieldToEvaluate);
                    Matcher m = ((RegexEvalData)this.data).pattern.matcher(fieldValue);
                    isMatch = m.matches();
                    if (((RegexEvalMeta)this.meta).isAllowCaptureGroupsFlagSet() && ((RegexEvalData)this.data).positions.length != m.groupCount()) {
                        this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorCaptureGroupFieldsMismatch", (String[])new String[]{String.valueOf(m.groupCount()), String.valueOf(((RegexEvalData)this.data).positions.length)}));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorCaptureGroupFieldsMismatch", (String[])new String[]{String.valueOf(m.groupCount()), String.valueOf(((RegexEvalData)this.data).positions.length)}));
                    }
                    for (int i = 0; i < ((RegexEvalData)this.data).positions.length; ++i) {
                        Object convertedValue;
                        int index = ((RegexEvalData)this.data).positions[i];
                        String value = isMatch ? m.group(i + 1) : null;
                        if (value == null) {
                            try {
                                value = ((RegexEvalData)this.data).outputRowMeta.getString(outputRow, index);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                        IValueMeta valueMeta = ((RegexEvalData)this.data).outputRowMeta.getValueMeta(index);
                        IValueMeta conversionValueMeta = ((RegexEvalData)this.data).conversionRowMeta.getValueMeta(index);
                        outputRow[index] = convertedValue = valueMeta.convertDataFromString(value, conversionValueMeta, ((RegexEvalMeta)this.meta).getFieldNullIf()[i], ((RegexEvalMeta)this.meta).getFieldIfNull()[i], ((RegexEvalMeta)this.meta).getFieldTrimType()[i]);
                    }
                }
                if (((RegexEvalData)this.data).indexOfResultField >= 0) {
                    outputRow[((RegexEvalData)this.data).indexOfResultField] = isMatch;
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"RegexEval.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
                }
                this.putRow(((RegexEvalData)this.data).outputRowMeta, outputRow);
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorInTransform", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block24;
                this.putError(this.getInputRowMeta(), outputRow, 1L, errorMessage, null, "REGEX001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            String options = ((RegexEvalMeta)this.meta).getRegexOptions();
            String regularexpression = ((RegexEvalMeta)this.meta).getScript();
            if (((RegexEvalMeta)this.meta).isUseVariableInterpolationFlagSet()) {
                regularexpression = this.resolve(((RegexEvalMeta)this.meta).getScript());
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RegexEval.Log.Regexp", (String[])new String[0]) + " " + options + regularexpression);
            }
            ((RegexEvalData)this.data).pattern = ((RegexEvalMeta)this.meta).isCanonicalEqualityFlagSet() ? Pattern.compile(options + regularexpression, 128) : Pattern.compile(options + regularexpression);
            return true;
        }
        return false;
    }
}

