/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.XMP;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.DomXmpParser;

public class XMPMetadataExtractor {
    public static void parse(InputStream stream, Metadata metadata) throws IOException, TikaException {
        XMPMetadata xmp;
        try {
            DomXmpParser xmpParser = new DomXmpParser();
            xmpParser.setStrictParsing(false);
            xmp = xmpParser.parse((InputStream)new CloseShieldInputStream(stream));
        }
        catch (Throwable ex) {
            return;
        }
        XMPMetadataExtractor.extractDublinCoreSchema(xmp, metadata);
        XMPMetadataExtractor.extractXMPBasicSchema(xmp, metadata);
    }

    public static void extractDublinCoreSchema(XMPMetadata xmp, Metadata metadata) throws IOException {
        DublinCoreSchema schemaDublinCore;
        if (xmp == null) {
            return;
        }
        try {
            schemaDublinCore = xmp.getDublinCoreSchema();
        }
        catch (Throwable e) {
            return;
        }
        if (schemaDublinCore != null) {
            try {
                XMPMetadataExtractor.addMetadata(metadata, DublinCore.TITLE, schemaDublinCore.getTitle());
                XMPMetadataExtractor.addMetadata(metadata, DublinCore.FORMAT, schemaDublinCore.getFormat());
                XMPMetadataExtractor.addMetadata(metadata, DublinCore.DESCRIPTION, schemaDublinCore.getDescription());
                XMPMetadataExtractor.addMetadata(metadata, DublinCore.CREATOR, schemaDublinCore.getCreators());
                XMPMetadataExtractor.addMetadata(metadata, DublinCore.SUBJECT, schemaDublinCore.getSubjects());
            }
            catch (BadFieldValueException ex) {
                throw new IOException(ex);
            }
        }
    }

    public static void extractXMPBasicSchema(XMPMetadata xmp, Metadata metadata) throws IOException {
        XMPBasicSchema schemaBasic;
        if (xmp == null) {
            return;
        }
        try {
            schemaBasic = xmp.getXMPBasicSchema();
        }
        catch (Throwable e) {
            return;
        }
        if (schemaBasic != null) {
            XMPMetadataExtractor.addMetadata(metadata, XMP.CREATOR_TOOL, schemaBasic.getCreatorTool());
            XMPMetadataExtractor.addMetadata(metadata, XMP.CREATE_DATE, schemaBasic.getCreateDate().getTime());
            XMPMetadataExtractor.addMetadata(metadata, XMP.MODIFY_DATE, schemaBasic.getModifyDate().getTime());
            XMPMetadataExtractor.addMetadata(metadata, XMP.METADATA_DATE, schemaBasic.getModifyDate().getTime());
            XMPMetadataExtractor.addMetadata(metadata, XMP.RATING, schemaBasic.getRating());
        }
    }

    private static void addMetadata(Metadata metadata, Property property, List<String> values) {
        if (values != null) {
            for (String value : values) {
                XMPMetadataExtractor.addMetadata(metadata, property, value);
            }
        }
    }

    private static void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            if (property.isMultiValuePermitted()) {
                metadata.add(property, value);
            } else {
                metadata.set(property, value);
            }
        }
    }

    private static void addMetadata(Metadata metadata, Property property, Integer value) {
        if (value != null) {
            if (property.isMultiValuePermitted()) {
                metadata.add(property, value.intValue());
            } else {
                metadata.set(property, value.intValue());
            }
        }
    }

    private static void addMetadata(Metadata metadata, Property property, Date value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }
}

