/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCArray;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class SQLArray
implements SQLData {
    static final String copyright = "Copyright (C) 2009-2010 International Business Machines Corporation and others.";
    private SQLData[] values_;
    private int arrayCount_ = 0;
    private SQLData contentTemplate_;
    private int elemDataTypeLen_ = 0;
    private int vrm_;
    private Object savedValue_ = null;

    SQLArray() {
    }

    public SQLArray(int elemDataTypeLen, SQLData contentTemplate, int vrm) {
        this.values_ = null;
        this.contentTemplate_ = contentTemplate;
        this.vrm_ = vrm;
        this.elemDataTypeLen_ = elemDataTypeLen;
    }

    @Override
    public Object clone() {
        SQLArray cpy = new SQLArray(this.elemDataTypeLen_, this.contentTemplate_, this.vrm_);
        return cpy;
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter, boolean ignoreConversionErrors) throws SQLException {
        this.values_ = new SQLData[this.arrayCount_];
        for (int x = 0; x < this.arrayCount_; ++x) {
            this.values_[x] = (SQLData)this.contentTemplate_.clone();
            try {
                this.values_[x].convertFromRawBytes(rawBytes, offset, converter, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            offset += this.elemDataTypeLen_;
        }
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        for (int x = 0; x < this.arrayCount_; ++x) {
            if (this.values_ != null && this.values_[x] != null) {
                this.values_[x].convertToRawBytes(rawBytes, offset, ccsidConverter);
            } else {
                this.contentTemplate_.convertToRawBytes(rawBytes, offset, ccsidConverter);
            }
            offset += this.elemDataTypeLen_;
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        Object[] data = (Object[])((Array)object).getArray();
        if (data == null) {
            data = new Object[]{};
        }
        this.arrayCount_ = data.length;
        this.values_ = new SQLData[this.arrayCount_];
        boolean isSQLData = false;
        if (this.arrayCount_ > 0 && data[0] != null && data instanceof SQLData[]) {
            isSQLData = true;
        }
        for (int x = 0; x < this.arrayCount_; ++x) {
            this.values_[x] = (SQLData)this.contentTemplate_.clone();
            Object inObj = isSQLData ? ((SQLData)data[x]).getObject() : data[x];
            if (inObj == null) {
                this.setElementNull(x);
                continue;
            }
            this.values_[x].set(inObj, calendar, scale);
        }
    }

    @Override
    public int getActualSize() {
        int totalSize = 0;
        for (int x = 0; x < this.arrayCount_; ++x) {
            totalSize += this.values_[x].getActualSize();
        }
        return totalSize;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Clob getClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public NClob getNClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Array getArray() throws SQLException {
        return new AS400JDBCArray(this.contentTemplate_.getTypeName(), this.values_, this.vrm_, null);
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 0;
    }

    @Override
    public String getJavaClassName() {
        return "java.sql.Array";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "ARRAY";
    }

    @Override
    public int getMaximumPrecision() {
        return 0;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 10000;
    }

    public int getElementNativeType() {
        return this.contentTemplate_.getNativeType();
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getArray();
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getSQLType() {
        return 39;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getTruncated() {
        return 0;
    }

    @Override
    public void clearTruncated() {
    }

    @Override
    public boolean getOutOfBounds() {
        return false;
    }

    @Override
    public void clearOutOfBounds() {
    }

    @Override
    public int getType() {
        return 2003;
    }

    @Override
    public String getTypeName() {
        return "ARRAY";
    }

    @Override
    public boolean isSigned() {
        if (this.values_ != null && this.values_.length > 0 && this.values_[0] != null) {
            return this.values_[0].isSigned();
        }
        return false;
    }

    @Override
    public boolean isText() {
        if (this.values_ != null && this.values_.length > 0 && this.values_[0] != null) {
            return this.values_[0].isText();
        }
        return false;
    }

    public void setArrayCount(int count) {
        this.arrayCount_ = count;
    }

    public int getArrayCount() {
        return this.arrayCount_;
    }

    public void setElementNull(int element) {
        this.values_[element] = null;
    }

    public boolean isElementNull(int element) {
        return this.values_[element] == null;
    }

    @Override
    public void updateSettings(SQLConversionSettings settings) {
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.values_;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

